/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import jdk.graal.compiler.core.common.NumUtil;

public enum ReferenceType {
    None(0),
    Soft(1),
    Weak(2),
    Reserved(3),
    Phantom(4);

    private final byte value;

    private ReferenceType(int value) {
        this.value = NumUtil.safeToByte((long)value);
    }

    public byte getValue() {
        return this.value;
    }

    public static ReferenceType computeReferenceType(Class<?> type) {
        if (Reference.class.isAssignableFrom(type)) {
            if (PhantomReference.class.isAssignableFrom(type)) {
                return Phantom;
            }
            if (SoftReference.class.isAssignableFrom(type)) {
                return Soft;
            }
            return Weak;
        }
        return None;
    }
}

