/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.heap.ComputeQueueValue;
import com.oracle.svm.core.heap.ComputeReferenceValue;
import com.oracle.svm.core.heap.ExcludeFromReferenceMap;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.Target_java_lang_ref_ReferenceQueue;
import com.oracle.svm.core.heap.UnknownClass;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.Reference;

@UnknownClass
@TargetClass(value=Reference.class)
@Substitute
public final class Target_java_lang_ref_Reference<T> {
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FieldOffset, name="referent", declClass=Target_java_lang_ref_Reference.class)
    static long referentFieldOffset;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FieldOffset, name="queue", declClass=Target_java_lang_ref_Reference.class)
    static long queueFieldOffset;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FieldOffset, name="next", declClass=Target_java_lang_ref_Reference.class)
    static long nextFieldOffset;
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FieldOffset, name="discovered", declClass=Target_java_lang_ref_Reference.class)
    static long discoveredFieldOffset;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ComputeReferenceValue.class)
    @ExcludeFromReferenceMap(reason="The GC processes this field manually.")
    T referent;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    @ExcludeFromReferenceMap(reason="The GC processes this field manually.")
    transient Target_java_lang_ref_Reference<?> discovered;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ComputeQueueValue.class)
    volatile Target_java_lang_ref_ReferenceQueue<? super T> queue;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    volatile Reference<?> next;

    @Substitute
    Target_java_lang_ref_Reference(T referent) {
        this(referent, null);
    }

    @Substitute
    @Uninterruptible(reason="The initialization of the fields must be atomic with respect to collection.")
    Target_java_lang_ref_Reference(T referent, Target_java_lang_ref_ReferenceQueue<? super T> queue) {
        this.referent = referent;
        this.queue = queue == null ? Target_java_lang_ref_ReferenceQueue.NULL_QUEUE : queue;
    }

    @KeepOriginal
    native T get();

    @KeepOriginal
    native void clear();

    @Substitute
    private void clear0() {
        ReferenceInternals.clear(SubstrateUtil.cast(this, Reference.class));
    }

    @KeepOriginal
    native void clearImpl();

    @KeepOriginal
    native boolean refersToImpl(T var1);

    @KeepOriginal
    public native boolean refersTo(T var1);

    @Substitute
    boolean refersTo0(Object obj) {
        return ReferenceInternals.refersTo(SubstrateUtil.cast(this, Reference.class), obj);
    }

    @KeepOriginal
    native boolean enqueue();

    @KeepOriginal
    native boolean isEnqueued();

    @Substitute
    static boolean waitForReferenceProcessing() throws InterruptedException {
        return ReferenceInternals.waitForReferenceProcessing();
    }

    @KeepOriginal
    protected native Object clone() throws CloneNotSupportedException;

    @Substitute
    static void reachabilityFence(Object ref) {
        throw VMError.shouldNotReachHere("Unreachable, intrinsified during bytecode parsing");
    }

    @KeepOriginal
    native T getFromInactiveFinalReference();

    @Substitute
    void clearInactiveFinalReference() {
        assert (this.next != null);
        ReferenceInternals.clear(SubstrateUtil.cast(this, Reference.class));
    }
}

