/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.stackvalue;

import com.oracle.svm.core.graal.stackvalue.LoweredStackValueNode;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.Phase;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class StackValueRecursionDepthPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        for (LoweredStackValueNode node : graph.getNodes(LoweredStackValueNode.TYPE)) {
            if (node.slotIdentity.shared) continue;
            int recursionDepth = StackValueRecursionDepthPhase.computeRecursionDepth(node);
            node.setRecursionDepth(recursionDepth);
        }
    }

    private static int computeRecursionDepth(StackValueNode node) {
        int result = 0;
        FrameState cur = node.stateAfter();
        ResolvedJavaMethod method = cur.getMethod();
        while ((cur = cur.outerFrameState()) != null) {
            if (!method.equals((Object)cur.getMethod())) continue;
            ++result;
        }
        return result;
    }
}

