/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateIntrinsics;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.graal.word.DynamicHubAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SharedType;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.core.common.calc.UnsignedMath;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.InstanceOfDynamicNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.InstanceOfSnippetsTemplates;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public class TypeSnippets
extends SubstrateTemplates
implements Snippets {
    protected final KnownOffsets knownOffsets = KnownOffsets.singleton();
    final SnippetTemplate.SnippetInfo instanceOf;
    final SnippetTemplate.SnippetInfo instanceOfDynamic;
    final SnippetTemplate.SnippetInfo typeEquality;
    final SnippetTemplate.SnippetInfo assignableTypeCheck;

    @Snippet
    protected static SubstrateIntrinsics.Any typeEqualitySnippet(Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter boolean allowsNull, DynamicHub exactType) {
        if (allowsNull) {
            if (BranchProbabilityNode.probability((double)0.09999999999999998, (object == null ? 1 : 0) != 0)) {
                return trueValue;
            }
            GuardingNode guard = SnippetAnchorNode.anchor();
            Object nonNullObject = PiNode.piCastNonNull((Object)object, (GuardingNode)guard);
            DynamicHub nonNullHub = SubstrateIntrinsics.loadHub(nonNullObject);
            if (BranchProbabilityNode.probability((double)0.09999999999999998, (nonNullHub != exactType ? 1 : 0) != 0)) {
                return falseValue;
            }
            return trueValue;
        }
        DynamicHub hubOrNull = SubstrateIntrinsics.loadHubOrNull(object);
        if (BranchProbabilityNode.probability((double)0.09999999999999998, (hubOrNull != exactType ? 1 : 0) != 0)) {
            return falseValue;
        }
        return trueValue;
    }

    @Snippet
    protected static SubstrateIntrinsics.Any instanceOfSnippet(Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter boolean allowsNull, short start, short range, short slot, @Snippet.ConstantParameter int typeIDSlotOffset) {
        if (BranchProbabilityNode.probability((double)0.09999999999999998, (object == null ? 1 : 0) != 0)) {
            if (allowsNull) {
                return trueValue;
            }
            return falseValue;
        }
        GuardingNode guard = SnippetAnchorNode.anchor();
        Object nonNullObject = PiNode.piCastNonNull((Object)object, (GuardingNode)guard);
        DynamicHub nonNullHub = SubstrateIntrinsics.loadHub(nonNullObject);
        return TypeSnippets.slotTypeCheck(start, range, slot, typeIDSlotOffset, nonNullHub, trueValue, falseValue);
    }

    @Snippet
    protected static SubstrateIntrinsics.Any instanceOfDynamicSnippet(@Snippet.NonNullParameter DynamicHub type, Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter boolean allowsNull, @Snippet.ConstantParameter int typeIDSlotOffset) {
        if (BranchProbabilityNode.probability((double)0.09999999999999998, (object == null ? 1 : 0) != 0)) {
            if (allowsNull) {
                return trueValue;
            }
            return falseValue;
        }
        GuardingNode guard = SnippetAnchorNode.anchor();
        Object nonNullObject = PiNode.piCastNonNull((Object)object, (GuardingNode)guard);
        DynamicHub nonNullHub = SubstrateIntrinsics.loadHub(nonNullObject);
        return TypeSnippets.slotTypeCheck(type.getTypeCheckStart(), type.getTypeCheckRange(), type.getTypeCheckSlot(), typeIDSlotOffset, nonNullHub, trueValue, falseValue);
    }

    @Snippet
    protected static SubstrateIntrinsics.Any classIsAssignableFromSnippet(@Snippet.NonNullParameter DynamicHub type, @Snippet.NonNullParameter DynamicHub checkedHub, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter int typeIDSlotOffset) {
        return TypeSnippets.slotTypeCheck(type.getTypeCheckStart(), type.getTypeCheckRange(), type.getTypeCheckSlot(), typeIDSlotOffset, checkedHub, trueValue, falseValue);
    }

    protected static SubstrateIntrinsics.Any slotTypeCheck(short start, short range, short slot, int typeIDSlotOffset, DynamicHub checkedHub, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue) {
        GuardingNode guard;
        int typeCheckStart = Short.toUnsignedInt(start);
        int typeCheckRange = Short.toUnsignedInt(range);
        int typeCheckSlot = Short.toUnsignedInt(slot) * 2;
        int checkedTypeID = Short.toUnsignedInt(DynamicHubAccess.readShort(checkedHub, typeIDSlotOffset + typeCheckSlot, NamedLocationIdentity.FINAL_LOCATION, guard = null));
        if (BranchProbabilityNode.probability((double)0.6, (boolean)UnsignedMath.belowThan((int)(checkedTypeID - typeCheckStart), (int)typeCheckRange))) {
            return trueValue;
        }
        return falseValue;
    }

    public void registerLowerings(Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, Providers providers) {
        lowerings.put(InstanceOfNode.class, new InstanceOfLowering(this.options, providers));
        lowerings.put(InstanceOfDynamicNode.class, new InstanceOfDynamicLowering(this.options, providers));
        lowerings.put(ClassIsAssignableFromNode.class, new ClassIsAssignableFromLowering(this.options, providers));
    }

    protected TypeSnippets(OptionValues options, Providers providers) {
        super(options, providers);
        this.instanceOf = this.snippet(providers, TypeSnippets.class, "instanceOfSnippet", new LocationIdentity[0]);
        this.instanceOfDynamic = this.snippet(providers, TypeSnippets.class, "instanceOfDynamicSnippet", new LocationIdentity[0]);
        this.typeEquality = this.snippet(providers, TypeSnippets.class, "typeEqualitySnippet", new LocationIdentity[0]);
        this.assignableTypeCheck = this.snippet(providers, TypeSnippets.class, "classIsAssignableFromSnippet", new LocationIdentity[0]);
    }

    protected class InstanceOfLowering
    extends InstanceOfSnippetsTemplates
    implements NodeLoweringProvider<FloatingNode> {
        public InstanceOfLowering(OptionValues options, Providers providers) {
            super(options, providers);
        }

        @Override
        public void lower(FloatingNode node, LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.MID_TIER) {
                return;
            }
            super.lower(node, tool);
        }

        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            InstanceOfNode node = (InstanceOfNode)replacer.instanceOf;
            TypeReference typeReference = node.type();
            SharedType type = (SharedType)typeReference.getType();
            DynamicHub hub = type.getHub();
            if (typeReference.isExact()) {
                args = new SnippetTemplate.Arguments(TypeSnippets.this.typeEquality, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("object", (Object)node.getValue());
                args.add("trueValue", (Object)replacer.trueValue);
                args.add("falseValue", (Object)replacer.falseValue);
                args.add("allowsNull", (Object)node.allowsNull());
                args.add("exactType", (Object)hub);
            } else {
                args = this.makeArgumentsForInexactType(replacer, tool, node, type, hub);
            }
            return args;
        }

        protected SnippetTemplate.Arguments makeArgumentsForInexactType(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool, InstanceOfNode node, SharedType type, DynamicHub hub) {
            assert (type.getSingleImplementor() == null) : "Canonicalization of InstanceOfNode produces exact type for single implementor";
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(TypeSnippets.this.instanceOf, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("object", (Object)node.getValue());
            args.add("trueValue", (Object)replacer.trueValue);
            args.add("falseValue", (Object)replacer.falseValue);
            args.add("allowsNull", (Object)node.allowsNull());
            args.add("start", (Object)hub.getTypeCheckStart());
            args.add("range", (Object)hub.getTypeCheckRange());
            args.add("slot", (Object)hub.getTypeCheckSlot());
            args.add("typeIDSlotOffset", (Object)TypeSnippets.this.knownOffsets.getTypeIDSlotsOffset());
            return args;
        }
    }

    protected class InstanceOfDynamicLowering
    extends InstanceOfSnippetsTemplates
    implements NodeLoweringProvider<FloatingNode> {
        public InstanceOfDynamicLowering(OptionValues options, Providers providers) {
            super(options, providers);
        }

        @Override
        public void lower(FloatingNode node, LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.MID_TIER) {
                return;
            }
            super.lower(node, tool);
        }

        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            InstanceOfDynamicNode node = (InstanceOfDynamicNode)replacer.instanceOf;
            if (node.isExact()) {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(TypeSnippets.this.typeEquality, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("object", (Object)node.getObject());
                args.add("trueValue", (Object)replacer.trueValue);
                args.add("falseValue", (Object)replacer.falseValue);
                args.add("allowsNull", (Object)node.allowsNull());
                args.add("exactType", (Object)node.getMirrorOrHub());
                return args;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(TypeSnippets.this.instanceOfDynamic, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("type", (Object)node.getMirrorOrHub());
            args.add("object", (Object)node.getObject());
            args.add("trueValue", (Object)replacer.trueValue);
            args.add("falseValue", (Object)replacer.falseValue);
            args.add("allowsNull", (Object)node.allowsNull());
            args.add("typeIDSlotOffset", (Object)TypeSnippets.this.knownOffsets.getTypeIDSlotsOffset());
            return args;
        }
    }

    protected class ClassIsAssignableFromLowering
    extends InstanceOfSnippetsTemplates
    implements NodeLoweringProvider<FloatingNode> {
        public ClassIsAssignableFromLowering(OptionValues options, Providers providers) {
            super(options, providers);
        }

        @Override
        public void lower(FloatingNode node, LoweringTool tool) {
            if (tool.getLoweringStage() != LoweringTool.StandardLoweringStage.MID_TIER) {
                return;
            }
            super.lower(node, tool);
        }

        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            ClassIsAssignableFromNode node = (ClassIsAssignableFromNode)replacer.instanceOf;
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(TypeSnippets.this.assignableTypeCheck, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("type", (Object)node.getThisClass());
            args.add("checkedHub", (Object)node.getOtherClass());
            args.add("trueValue", (Object)replacer.trueValue);
            args.add("falseValue", (Object)replacer.falseValue);
            args.add("typeIDSlotOffset", (Object)TypeSnippets.this.knownOffsets.getTypeIDSlotsOffset());
            return args;
        }
    }
}

