/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.nodes;

import com.oracle.svm.core.FrameAccess;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_1, size=NodeSize.SIZE_1)
public final class ReadReturnAddressNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<ReadReturnAddressNode> TYPE = NodeClass.create(ReadReturnAddressNode.class);

    public ReadReturnAddressNode() {
        super(TYPE, FrameAccess.getWordStamp());
    }

    public void generate(NodeLIRBuilderTool gen) {
        assert (FrameAccess.returnAddressSize() > 0);
        Value result = gen.getLIRGeneratorTool().emitReadReturnAddress(FrameAccess.getWordStamp(), FrameAccess.returnAddressSize());
        gen.setResult((ValueNode)this, result);
    }
}

