/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.jdk;

import com.oracle.svm.core.JavaMemoryUtil;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.ArrayUtil;
import java.util.Map;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.extended.ForeignCallWithExceptionNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyNode;
import jdk.graal.compiler.replacements.nodes.BasicArrayCopyNode;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public final class SubstrateArraycopySnippets
extends SubstrateTemplates
implements Snippets {
    private static final SnippetRuntime.SubstrateForeignCallDescriptor ARRAYCOPY = SnippetRuntime.findForeignCall(SubstrateArraycopySnippets.class, "doArraycopy", ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any());
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{ARRAYCOPY};

    public static void registerForeignCalls(SubstrateForeignCallsProvider foreignCalls) {
        foreignCalls.register(FOREIGN_CALLS);
    }

    protected SubstrateArraycopySnippets(OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, providers);
        lowerings.put(ArrayCopyNode.class, new SubstrateArrayCopyLowering());
    }

    @SubstrateForeignCallTarget(stubCallingConvention=false)
    private static void doArraycopy(Object fromArray, int fromIndex, Object toArray, int toIndex, int length) {
        if (fromArray == null || toArray == null) {
            throw new NullPointerException();
        }
        DynamicHub fromHub = KnownIntrinsics.readHub(fromArray);
        DynamicHub toHub = KnownIntrinsics.readHub(toArray);
        int fromLayoutEncoding = fromHub.getLayoutEncoding();
        if (LayoutEncoding.isPrimitiveArray(fromLayoutEncoding)) {
            if (fromArray == toArray && fromIndex < toIndex) {
                ArrayUtil.boundsCheckInSnippet(fromArray, fromIndex, toArray, toIndex, length);
                JavaMemoryUtil.copyPrimitiveArrayBackward(fromArray, fromIndex, fromArray, toIndex, length, fromLayoutEncoding);
                return;
            }
            if (fromHub == toHub) {
                ArrayUtil.boundsCheckInSnippet(fromArray, fromIndex, toArray, toIndex, length);
                JavaMemoryUtil.copyPrimitiveArrayForward(fromArray, fromIndex, toArray, toIndex, length, fromLayoutEncoding);
                return;
            }
        } else if (LayoutEncoding.isObjectArray(fromLayoutEncoding)) {
            if (fromArray == toArray && fromIndex < toIndex) {
                ArrayUtil.boundsCheckInSnippet(fromArray, fromIndex, toArray, toIndex, length);
                JavaMemoryUtil.copyObjectArrayBackward(fromArray, fromIndex, fromArray, toIndex, length, fromLayoutEncoding);
                return;
            }
            if (fromHub == toHub) {
                ArrayUtil.boundsCheckInSnippet(fromArray, fromIndex, toArray, toIndex, length);
                JavaMemoryUtil.copyObjectArrayForward(fromArray, fromIndex, toArray, toIndex, length, fromLayoutEncoding);
                return;
            }
            if (LayoutEncoding.isObjectArray(toHub.getLayoutEncoding())) {
                ArrayUtil.boundsCheckInSnippet(fromArray, fromIndex, toArray, toIndex, length);
                if (DynamicHub.toClass(toHub).isAssignableFrom(DynamicHub.toClass(fromHub))) {
                    JavaMemoryUtil.copyObjectArrayForward(fromArray, fromIndex, toArray, toIndex, length, fromLayoutEncoding);
                } else {
                    JavaMemoryUtil.copyObjectArrayForwardWithStoreCheck(fromArray, fromIndex, toArray, toIndex, length);
                }
                return;
            }
        }
        throw new ArrayStoreException();
    }

    static final class SubstrateArrayCopyLowering
    implements NodeLoweringProvider<ArrayCopyNode> {
        SubstrateArrayCopyLowering() {
        }

        @Override
        public void lower(ArrayCopyNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            ForeignCallWithExceptionNode call = (ForeignCallWithExceptionNode)graph.add((Node)new ForeignCallWithExceptionNode((ForeignCallDescriptor)ARRAYCOPY, new ValueNode[]{node.getSource(), node.getSourcePosition(), node.getDestination(), node.getDestinationPosition(), node.getLength()}));
            call.setStateAfter(node.stateAfter());
            call.setStateDuring(node.stateDuring());
            call.setBci(node.bci());
            graph.replaceWithExceptionSplit((WithExceptionNode)node, (WithExceptionNode)call);
        }
    }

    @NodeInfo(allowedUsageTypes={InputType.Memory, InputType.Value}, cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
    public static final class SubstrateGenericArrayCopyCallNode
    extends BasicArrayCopyNode
    implements Lowerable {
        public static final NodeClass<SubstrateGenericArrayCopyCallNode> TYPE = NodeClass.create(SubstrateGenericArrayCopyCallNode.class);

        public SubstrateGenericArrayCopyCallNode(ValueNode src, ValueNode srcPos, ValueNode dest, ValueNode destPos, ValueNode length, JavaKind elementKind) {
            super(TYPE, src, srcPos, dest, destPos, length, elementKind);
        }

        public void lower(LoweringTool tool) {
            if (this.graph().getGuardsStage().areFrameStatesAtDeopts()) {
                StructuredGraph graph = this.graph();
                ForeignCallWithExceptionNode call = (ForeignCallWithExceptionNode)graph.add((Node)new ForeignCallWithExceptionNode((ForeignCallDescriptor)ARRAYCOPY, new ValueNode[]{this.getSource(), this.getSourcePosition(), this.getDestination(), this.getDestinationPosition(), this.getLength()}));
                call.setStateAfter(this.stateAfter());
                call.setStateDuring(this.stateDuring());
                call.setBci(this.bci());
                graph.replaceWithExceptionSplit((WithExceptionNode)this, (WithExceptionNode)call);
            }
        }

        @Node.NodeIntrinsic
        public static native int genericArraycopy(Object var0, int var1, Object var2, int var3, int var4, @Node.ConstantNodeParameter JavaKind var5);
    }
}

