/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.code;

import java.util.Objects;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaKind;

public final class AssignedLocation {
    private static final int NONE = -1;
    private static final AssignedLocation PLACEHOLDER = new AssignedLocation();
    private final Register register;
    private final JavaKind registerKind;
    private final int stackOffset;

    private static boolean isValidOffset(int i) {
        return i >= 0 || i == -1;
    }

    private void checkClassInvariant() {
        if (!AssignedLocation.isValidOffset(this.stackOffset)) {
            throw new IllegalStateException("Stack offset cannot be < 0 (and not NONE).");
        }
        if (this.assignsToRegister() && this.registerKind == null) {
            throw new IllegalStateException("Missing register kind.");
        }
        if (this.assignsToStack() == this.assignsToRegister()) {
            throw new IllegalStateException("Cannot assign to both register and stack.");
        }
    }

    private AssignedLocation() {
        this.register = null;
        this.registerKind = null;
        this.stackOffset = -1;
    }

    private AssignedLocation(Register register, JavaKind kind, int stackOffset) {
        this.register = register;
        this.registerKind = kind;
        this.stackOffset = stackOffset;
        this.checkClassInvariant();
    }

    public static AssignedLocation placeholder() {
        return PLACEHOLDER;
    }

    public static AssignedLocation forRegister(Register register, JavaKind kind) {
        Objects.requireNonNull(register, "Register cannot be null");
        Objects.requireNonNull(kind, "Kind cannot be null");
        if (kind != JavaKind.Long && kind != JavaKind.Double) {
            throw new IllegalArgumentException("Register kind cannot be " + String.valueOf(kind));
        }
        return new AssignedLocation(register, kind, -1);
    }

    public static AssignedLocation forStack(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Stack offset must be >= 0");
        }
        return new AssignedLocation(null, null, offset);
    }

    public boolean isPlaceholder() {
        return !this.assignsToRegister() && !this.assignsToStack();
    }

    public boolean assignsToRegister() {
        return this.register != null;
    }

    public boolean assignsToStack() {
        return this.stackOffset >= 0;
    }

    public Register register() {
        if (this.register == null) {
            throw new IllegalStateException("Not a register assignment.");
        }
        return this.register;
    }

    public JavaKind registerKind() {
        if (this.register == null) {
            throw new IllegalStateException("Cannot get register kind of a stack location.");
        }
        return this.registerKind;
    }

    public int stackOffset() {
        if (this.stackOffset == -1) {
            throw new IllegalStateException("Not a stack assignment.");
        }
        return this.stackOffset;
    }

    public String toString() {
        if (this.assignsToRegister()) {
            return "r-" + String.valueOf(this.register);
        }
        if (this.assignsToStack()) {
            return "s-" + this.stackOffset;
        }
        return "p";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignedLocation that = (AssignedLocation)o;
        return this.stackOffset == that.stackOffset && Objects.equals(this.register, that.register);
    }

    public int hashCode() {
        return Objects.hash(this.register, this.stackOffset);
    }
}

