/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.ReservedRegisters;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class AMD64ReservedRegisters
extends ReservedRegisters {
    public static final Register THREAD_REGISTER = AMD64.r15;
    public static final Register HEAP_BASE_REGISTER = AMD64.r14;
    public static final Register CODE_BASE_REGISTER_CANDIDATE = AMD64.r13;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    AMD64ReservedRegisters() {
        super(AMD64.rsp, THREAD_REGISTER, HEAP_BASE_REGISTER, CODE_BASE_REGISTER_CANDIDATE);
    }

    @Override
    public boolean isReservedRegister(Register reg) {
        return super.isReservedRegister(reg) || reg.equals((Object)AMD64.rip);
    }
}

