/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class AMD64CGlobalDataLoadAddressOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64CGlobalDataLoadAddressOp> TYPE = LIRInstructionClass.create(AMD64CGlobalDataLoadAddressOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private AllocatableValue result;
    private final CGlobalDataInfo dataInfo;
    private final int addend;

    AMD64CGlobalDataLoadAddressOp(CGlobalDataInfo dataInfo, AllocatableValue result, int addend) {
        super(TYPE);
        assert (dataInfo != null);
        this.dataInfo = dataInfo;
        this.result = result;
        this.addend = addend;
    }

    AMD64CGlobalDataLoadAddressOp(CGlobalDataInfo dataInfo, AllocatableValue result) {
        this(dataInfo, result, 0);
    }

    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        int before = masm.position();
        AMD64Address address = masm.getPlaceholder(before);
        if (this.dataInfo.isSymbolReference()) {
            masm.movq(resultReg, address);
        } else {
            masm.leaq(resultReg, address);
        }
        crb.compilationResult.recordDataPatch(before, (Reference)new CGlobalDataReference(this.dataInfo));
        if (this.addend != 0) {
            masm.addq(resultReg, this.addend);
        }
    }
}

