/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.graal;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.gc.SerialWriteBarrierNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;

@NodeInfo(cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_4)
public final class ForcedSerialPostWriteBarrier
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<ForcedSerialPostWriteBarrier> TYPE = NodeClass.create(ForcedSerialPostWriteBarrier.class);
    @Node.Input(value=InputType.Association)
    AddressNode address;
    private final boolean precise;

    public ForcedSerialPostWriteBarrier(ValueNode address, boolean precise) {
        super(TYPE, StampFactory.forVoid());
        this.address = (AddressNode)address;
        this.precise = precise;
    }

    public void lower(LoweringTool tool) {
        if (this.graph().getGuardsStage().areFrameStatesAtDeopts()) {
            SerialWriteBarrierNode barrier = (SerialWriteBarrierNode)this.graph().add((Node)new SerialWriteBarrierNode(this.address, this.precise));
            this.graph().replaceFixedWithFixed((FixedWithNextNode)this, (FixedWithNextNode)barrier);
            tool.getLowerer().lower((Node)barrier, tool);
        }
    }

    @Node.NodeIntrinsic
    public static native void force(AddressNode.Address var0, @Node.ConstantNodeParameter boolean var1);
}

