/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.SerialGCOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class SerialGCOptions_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(SerialGCOptions.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "CollectYoungGenerationSeparately": {
                return OptionDescriptor.create((String)"CollectYoungGenerationSeparately", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines if a full GC collects the young generation separately or together with the old generation. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.CollectYoungGenerationSeparately, (String)"CollectYoungGenerationSeparately", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "GreyToBlackObjRefDemographics": {
                return OptionDescriptor.create((String)"GreyToBlackObjRefDemographics", (OptionType)OptionType.Debug, Boolean.class, (String)"Develop demographics of the object references visited. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.GreyToBlackObjRefDemographics, (String)"GreyToBlackObjRefDemographics", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "IgnoreMaxHeapSizeWhileInVMInternalCode": {
                return OptionDescriptor.create((String)"IgnoreMaxHeapSizeWhileInVMInternalCode", (OptionType)OptionType.Expert, Boolean.class, (String)"Ignore the maximum heap size while in VM-internal code. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.IgnoreMaxHeapSizeWhileInVMInternalCode, (String)"IgnoreMaxHeapSizeWhileInVMInternalCode", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ImageHeapCardMarking": {
                return OptionDescriptor.create((String)"ImageHeapCardMarking", (OptionType)OptionType.Expert, Boolean.class, (String)"Enables card marking for image heap objects, which arranges them in chunks. Automatically enabled when supported. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.ImageHeapCardMarking, (String)"ImageHeapCardMarking", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InitialCollectionPolicy": {
                return OptionDescriptor.create((String)"InitialCollectionPolicy", (OptionType)OptionType.User, String.class, (String)"The garbage collection policy, either Adaptive (default) or BySpaceAndTime. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.InitialCollectionPolicy, (String)"InitialCollectionPolicy", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxHeapFree": {
                return OptionDescriptor.create((String)"MaxHeapFree", (OptionType)OptionType.User, Long.class, (String)"The maximum free bytes reserved for allocations, in bytes (0 for automatic according to GC policy). Serial GC only.", (Object)this.getContainer(), SerialGCOptions.MaxHeapFree, (String)"MaxHeapFree", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaxSurvivorSpaces": {
                return OptionDescriptor.create((String)"MaxSurvivorSpaces", (OptionType)OptionType.Expert, Integer.class, (String)"Maximum number of survivor spaces. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.MaxSurvivorSpaces, (String)"MaxSurvivorSpaces", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "OutlineWriteBarriers": {
                return OptionDescriptor.create((String)"OutlineWriteBarriers", (OptionType)OptionType.Expert, Boolean.class, (String)"Determines whether to always (if true) or never (if false) outline write barrier code to a separate function, trading reduced image size for (potentially) worse performance. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.OutlineWriteBarriers, (String)"OutlineWriteBarriers", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PercentTimeInIncrementalCollection": {
                return OptionDescriptor.create((String)"PercentTimeInIncrementalCollection", (OptionType)OptionType.User, Integer.class, (String)"Percentage of total collection time that should be spent on young generation collections. Serial GC with collection policy 'BySpaceAndTime' only.", (Object)this.getContainer(), SerialGCOptions.PercentTimeInIncrementalCollection, (String)"PercentTimeInIncrementalCollection", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PrintGCSummary": {
                return OptionDescriptor.create((String)"PrintGCSummary", (OptionType)OptionType.Debug, Boolean.class, (String)"Print summary GC information after application main method returns. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.PrintGCSummary, (String)"PrintGCSummary", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PrintGCTimes": {
                return OptionDescriptor.create((String)"PrintGCTimes", (OptionType)OptionType.Debug, Boolean.class, (String)"Print the time for each of the phases of each collection, if +VerboseGC. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.PrintGCTimes, (String)"PrintGCTimes", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "SoftRefLRUPolicyMSPerMB": {
                return OptionDescriptor.create((String)"SoftRefLRUPolicyMSPerMB", (OptionType)OptionType.Expert, Integer.class, (String)"This number of milliseconds multiplied by the free heap memory in MByte is the time span for which a soft reference will keep its referent alive after its last access. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.SoftRefLRUPolicyMSPerMB, (String)"SoftRefLRUPolicyMSPerMB", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "TraceHeapChunks": {
                return OptionDescriptor.create((String)"TraceHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Trace heap chunks during collections, if +VerboseGC. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.TraceHeapChunks, (String)"TraceHeapChunks", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyAfterGC": {
                return OptionDescriptor.create((String)"VerifyAfterGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify the heap after doing a garbage collection if VerifyHeap is enabled. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.VerifyAfterGC, (String)"VerifyAfterGC", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyBeforeGC": {
                return OptionDescriptor.create((String)"VerifyBeforeGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify the heap before doing a garbage collection if VerifyHeap is enabled. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.VerifyBeforeGC, (String)"VerifyBeforeGC", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyDuringGC": {
                return OptionDescriptor.create((String)"VerifyDuringGC", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify the heap during a garbage collection if VerifyHeap is enabled. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.VerifyDuringGC, (String)"VerifyDuringGC", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyReferences": {
                return OptionDescriptor.create((String)"VerifyReferences", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify all object references if VerifyHeap is enabled. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.VerifyReferences, (String)"VerifyReferences", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyReferencesPointIntoValidChunk": {
                return OptionDescriptor.create((String)"VerifyReferencesPointIntoValidChunk", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify that object references point into valid heap chunks if VerifyHeap is enabled. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.VerifyReferencesPointIntoValidChunk, (String)"VerifyReferencesPointIntoValidChunk", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyRememberedSet": {
                return OptionDescriptor.create((String)"VerifyRememberedSet", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify the remembered set if VerifyHeap is enabled. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.VerifyRememberedSet, (String)"VerifyRememberedSet", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "VerifyWriteBarriers": {
                return OptionDescriptor.create((String)"VerifyWriteBarriers", (OptionType)OptionType.Debug, Boolean.class, (String)"Verify write barriers. Serial GC only.", (Object)this.getContainer(), SerialGCOptions.VerifyWriteBarriers, (String)"VerifyWriteBarriers", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 20;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return SerialGCOptions_OptionDescriptors.this.get("CollectYoungGenerationSeparately");
                    }
                    case 1: {
                        return SerialGCOptions_OptionDescriptors.this.get("GreyToBlackObjRefDemographics");
                    }
                    case 2: {
                        return SerialGCOptions_OptionDescriptors.this.get("IgnoreMaxHeapSizeWhileInVMInternalCode");
                    }
                    case 3: {
                        return SerialGCOptions_OptionDescriptors.this.get("ImageHeapCardMarking");
                    }
                    case 4: {
                        return SerialGCOptions_OptionDescriptors.this.get("InitialCollectionPolicy");
                    }
                    case 5: {
                        return SerialGCOptions_OptionDescriptors.this.get("MaxHeapFree");
                    }
                    case 6: {
                        return SerialGCOptions_OptionDescriptors.this.get("MaxSurvivorSpaces");
                    }
                    case 7: {
                        return SerialGCOptions_OptionDescriptors.this.get("OutlineWriteBarriers");
                    }
                    case 8: {
                        return SerialGCOptions_OptionDescriptors.this.get("PercentTimeInIncrementalCollection");
                    }
                    case 9: {
                        return SerialGCOptions_OptionDescriptors.this.get("PrintGCSummary");
                    }
                    case 10: {
                        return SerialGCOptions_OptionDescriptors.this.get("PrintGCTimes");
                    }
                    case 11: {
                        return SerialGCOptions_OptionDescriptors.this.get("SoftRefLRUPolicyMSPerMB");
                    }
                    case 12: {
                        return SerialGCOptions_OptionDescriptors.this.get("TraceHeapChunks");
                    }
                    case 13: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyAfterGC");
                    }
                    case 14: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyBeforeGC");
                    }
                    case 15: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyDuringGC");
                    }
                    case 16: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyReferences");
                    }
                    case 17: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyReferencesPointIntoValidChunk");
                    }
                    case 18: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyRememberedSet");
                    }
                    case 19: {
                        return SerialGCOptions_OptionDescriptors.this.get("VerifyWriteBarriers");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

