/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.remset.RememberedSet;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.UninterruptibleObjectReferenceVisitor;
import com.oracle.svm.core.log.Log;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class GreyToBlackObjRefVisitor
implements UninterruptibleObjectReferenceVisitor {
    private final Counters counters = SerialGCOptions.GreyToBlackObjRefDemographics.getValue() != false ? new RealCounters() : new NoopCounters();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    GreyToBlackObjRefVisitor() {
    }

    @Override
    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void visitObjectReferences(Pointer firstObjRef, boolean compressed, int referenceSize, Object holderObject, int count) {
        Pointer pos = firstObjRef;
        Pointer end = firstObjRef.add(Word.unsigned((int)count).multiply(referenceSize));
        while (pos.belowThan((UnsignedWord)end)) {
            this.visitObjectReference(pos, compressed, holderObject);
            pos = pos.add(referenceSize);
        }
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private void visitObjectReference(Pointer objRef, boolean compressed, Object holderObject) {
        assert (!objRef.isNull());
        this.counters.noteObjRef();
        Word p = ReferenceAccess.singleton().readObjectAsUntrackedPointer(objRef, compressed);
        if (p.isNull()) {
            this.counters.noteNullReferent();
            return;
        }
        if (HeapImpl.getHeapImpl().isInImageHeap((Pointer)p)) {
            this.counters.noteNonHeapReferent();
            return;
        }
        ObjectHeaderImpl ohi = ObjectHeaderImpl.getObjectHeaderImpl();
        Word header = ohi.readHeaderFromPointer((Pointer)p);
        if (GCImpl.getGCImpl().isCompleteCollection() || !RememberedSet.get().hasRememberedSet((UnsignedWord)header)) {
            if (ObjectHeaderImpl.isForwardedHeader((UnsignedWord)header)) {
                this.counters.noteForwardedReferent();
                Object obj = ohi.getForwardedObject((Pointer)p, (UnsignedWord)header);
                ReferenceAccess.singleton().writeObjectAt(objRef, obj, compressed);
                RememberedSet.get().dirtyCardIfNecessary(holderObject, obj, objRef);
                return;
            }
            Object obj = p.toObjectNonNull();
            if (SerialGCOptions.useCompactingOldGen() && ObjectHeaderImpl.isMarkedHeader((UnsignedWord)header)) {
                RememberedSet.get().dirtyCardIfNecessary(holderObject, obj, objRef);
                return;
            }
            Object copy = GCImpl.getGCImpl().promoteObject(obj, (UnsignedWord)header);
            if (copy != obj) {
                this.counters.noteCopiedReferent();
                ReferenceAccess.singleton().writeObjectAt(objRef, copy, compressed);
            } else {
                this.counters.noteUnmodifiedReference();
            }
            RememberedSet.get().dirtyCardIfNecessary(holderObject, copy, objRef);
        }
    }

    public Counters openCounters() {
        return this.counters.open();
    }

    public static class RealCounters
    implements Counters {
        private long objRef;
        private long nullObjRef;
        private long nullReferent;
        private long forwardedReferent;
        private long nonHeapReferent;
        private long copiedReferent;
        private long unmodifiedReference;

        RealCounters() {
            this.reset();
        }

        @Override
        public void reset() {
            this.objRef = 0L;
            this.nullObjRef = 0L;
            this.nullReferent = 0L;
            this.forwardedReferent = 0L;
            this.nonHeapReferent = 0L;
            this.copiedReferent = 0L;
            this.unmodifiedReference = 0L;
        }

        @Override
        public RealCounters open() {
            this.reset();
            return this;
        }

        @Override
        public void close() {
            this.toLog();
            this.reset();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteObjRef() {
            ++this.objRef;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNullReferent() {
            ++this.nullReferent;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteForwardedReferent() {
            ++this.forwardedReferent;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNonHeapReferent() {
            ++this.nonHeapReferent;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteCopiedReferent() {
            ++this.copiedReferent;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteUnmodifiedReference() {
            ++this.unmodifiedReference;
        }

        @Override
        public void toLog() {
            Log log = Log.log();
            log.string("[GreyToBlackObjRefVisitor.counters:");
            log.string("  objRef: ").signed(this.objRef);
            log.string("  nullObjRef: ").signed(this.nullObjRef);
            log.string("  nullReferent: ").signed(this.nullReferent);
            log.string("  forwardedReferent: ").signed(this.forwardedReferent);
            log.string("  nonHeapReferent: ").signed(this.nonHeapReferent);
            log.string("  copiedReferent: ").signed(this.copiedReferent);
            log.string("  unmodifiedReference: ").signed(this.unmodifiedReference);
            log.string("]").newline();
        }
    }

    public static interface Counters
    extends AutoCloseable {
        public Counters open();

        @Override
        public void close();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteObjRef();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNullReferent();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteForwardedReferent();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNonHeapReferent();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteCopiedReferent();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteUnmodifiedReference();

        public void toLog();

        public void reset();
    }

    public static class NoopCounters
    implements Counters {
        NoopCounters() {
        }

        @Override
        public NoopCounters open() {
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteObjRef() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNullReferent() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteForwardedReferent() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteNonHeapReferent() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteCopiedReferent() {
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void noteUnmodifiedReference() {
        }

        @Override
        public void toLog() {
        }

        @Override
        public void reset() {
        }
    }
}

