/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AdaptiveWeightedAverage;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

class AdaptiveWeightedAverageStruct {
    AdaptiveWeightedAverageStruct() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void initialize(Data data, double weight) {
        AdaptiveWeightedAverageStruct.initialize(data, weight, 0.0);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void initialize(Data data, double weight, double avg) {
        assert (weight > 0.0 && weight <= 100.0);
        data.setWeight(weight);
        data.setAverage(avg);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static double getAverage(Data data) {
        return data.getAverage();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void sample(Data data, double value) {
        data.setSampleCount(data.getSampleCount() + 1L);
        if (!data.getIsOld() && data.getSampleCount() > 100L) {
            data.setIsOld(true);
        }
        data.setAverage(AdaptiveWeightedAverageStruct.computeAdaptiveAverage(data, value, data.getAverage()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void sample(Data data, UnsignedWord value) {
        AdaptiveWeightedAverageStruct.sample(data, UnsignedUtils.toDouble(value));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static double computeAdaptiveAverage(Data data, double sample, double avg) {
        double countWeight = 0.0;
        if (!data.getIsOld()) {
            countWeight = 100.0 / (double)data.getSampleCount();
        }
        double adaptiveWeight = UninterruptibleUtils.Math.max(data.getWeight(), countWeight);
        return AdaptiveWeightedAverage.expAvg(avg, sample, adaptiveWeight);
    }

    @RawStructure
    static interface Data
    extends PointerBase {
        @RawField
        public void setWeight(double var1);

        @RawField
        public double getWeight();

        @RawField
        public void setAverage(double var1);

        @RawField
        public double getAverage();

        @RawField
        public void setSampleCount(long var1);

        @RawField
        public long getSampleCount();

        @RawField
        public void setIsOld(boolean var1);

        @RawField
        public boolean getIsOld();
    }
}

