/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.deopt.DeoptimizationCounters;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.deopt.VectorAPIDeoptimizationSupport;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.lang.reflect.Array;
import jdk.graal.compiler.core.common.util.TypeConversion;
import jdk.graal.compiler.word.Word;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.Pointer;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class DeoptState {
    final Pointer sourceSp;
    final IsolateThread targetThread;
    Object[] materializedObjects;

    public DeoptState(Pointer sourceSp, IsolateThread targetThread) {
        this.sourceSp = sourceSp;
        this.targetThread = targetThread;
        this.materializedObjects = null;
    }

    public JavaConstant readLocalVariable(int idx, FrameInfoQueryResult sourceFrame) {
        if (idx < 0 || idx >= sourceFrame.getNumLocals()) {
            throw Deoptimizer.fatalDeoptimizationError(String.format("Invalid idx: %s", idx), sourceFrame);
        }
        if (idx < sourceFrame.getValueInfos().length) {
            return this.readValue(sourceFrame.getValueInfos()[idx], sourceFrame);
        }
        return JavaConstant.forIllegal();
    }

    protected JavaConstant readValue(FrameInfoQueryResult.ValueInfo valueInfo, FrameInfoQueryResult sourceFrame) {
        switch (valueInfo.getType()) {
            case Constant: 
            case DefaultConstant: {
                return valueInfo.getValue();
            }
            case StackSlot: 
            case Register: {
                return DeoptState.readConstant(this.sourceSp, Word.signed((long)valueInfo.getData()), valueInfo.getKind(), valueInfo.isCompressedReference(), sourceFrame);
            }
            case ReservedRegister: {
                ReservedRegisters regs = ReservedRegisters.singleton();
                if (DeoptState.refersToRegister(valueInfo, regs.getThreadRegister())) {
                    return DeoptState.createWordConstant((WordBase)this.targetThread);
                }
                if (DeoptState.refersToRegister(valueInfo, regs.getHeapBaseRegister())) {
                    return DeoptState.createWordConstant((WordBase)CurrentIsolate.getIsolate());
                }
                if (DeoptState.refersToRegister(valueInfo, regs.getCodeBaseRegister())) {
                    return DeoptState.createWordConstant((WordBase)KnownIntrinsics.codeBase());
                }
                throw Deoptimizer.fatalDeoptimizationError("Unexpected reserved register: " + valueInfo.getData(), sourceFrame);
            }
            case VirtualObject: {
                Object obj = this.materializeObject(TypeConversion.asS4((long)valueInfo.getData()), sourceFrame);
                return SubstrateObjectConstant.forObject(obj, valueInfo.isCompressedReference());
            }
            case Illegal: {
                return JavaConstant.forIllegal();
            }
        }
        throw Deoptimizer.fatalDeoptimizationError("Unexpected type: " + String.valueOf((Object)valueInfo.getType()), sourceFrame);
    }

    private static boolean refersToRegister(FrameInfoQueryResult.ValueInfo valueInfo, Register register) {
        return register != null && valueInfo.getData() == (long)register.number;
    }

    private static PrimitiveConstant createWordConstant(WordBase word) {
        return JavaConstant.forIntegerKind((JavaKind)ConfigurationValues.getWordKind(), (long)word.rawValue());
    }

    private Object materializeObject(int virtualObjectId, FrameInfoQueryResult sourceFrame) {
        VectorAPIDeoptimizationSupport deoptSupport;
        VectorAPIDeoptimizationSupport.PayloadLayout payloadLayout;
        int curIdx;
        UnsignedWord curOffset;
        if (this.materializedObjects == null) {
            this.materializedObjects = new Object[sourceFrame.getVirtualObjects().length];
        }
        if (this.materializedObjects.length != sourceFrame.getVirtualObjects().length) {
            throw Deoptimizer.fatalDeoptimizationError(String.format("MaterializedObjects length (%s) does not match sourceFrame", this.materializedObjects.length), sourceFrame);
        }
        Object obj = this.materializedObjects[virtualObjectId];
        if (obj != null) {
            return obj;
        }
        DeoptimizationCounters.counters().virtualObjectsCount.inc();
        FrameInfoQueryResult.ValueInfo[] encodings = sourceFrame.getVirtualObjects()[virtualObjectId];
        DynamicHub hub = (DynamicHub)SubstrateObjectConstant.asObject((Constant)this.readValue(encodings[0], sourceFrame));
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        int layoutEncoding = hub.getLayoutEncoding();
        if (LayoutEncoding.isArray(layoutEncoding)) {
            int length = this.readValue(encodings[1], sourceFrame).asInt();
            obj = Array.newInstance(DynamicHub.toClass(hub.getComponentHub()), length);
            curOffset = LayoutEncoding.getArrayBaseOffset(hub.getLayoutEncoding());
            curIdx = 2;
        } else {
            if (!LayoutEncoding.isPureInstance(layoutEncoding)) {
                throw Deoptimizer.fatalDeoptimizationError("Non-pure instance layout encoding: " + layoutEncoding, sourceFrame);
            }
            try {
                obj = Unsafe.getUnsafe().allocateInstance(DynamicHub.toClass(hub));
            }
            catch (InstantiationException ex) {
                throw Deoptimizer.fatalDeoptimizationError("Instantiation exception: " + String.valueOf(ex), sourceFrame);
            }
            curOffset = Word.unsigned((int)objectLayout.getFirstFieldOffset());
            curIdx = 1;
        }
        this.materializedObjects[virtualObjectId] = obj;
        Deoptimizer.maybeTestGC();
        if (ImageSingletons.contains(VectorAPIDeoptimizationSupport.class) && (payloadLayout = (deoptSupport = (VectorAPIDeoptimizationSupport)ImageSingletons.lookup(VectorAPIDeoptimizationSupport.class)).getLayout(DynamicHub.toClass(hub))) != null) {
            Object payloadArray = deoptSupport.materializePayload(this, payloadLayout, encodings[curIdx], sourceFrame);
            JavaConstant arrayConstant = SubstrateObjectConstant.forObject(payloadArray, ReferenceAccess.singleton().haveCompressedReferences());
            Deoptimizer.writeValueInMaterializedObj(obj, curOffset, arrayConstant, sourceFrame);
            return obj;
        }
        while (curIdx < encodings.length) {
            FrameInfoQueryResult.ValueInfo value = encodings[curIdx];
            JavaKind kind = value.getKind();
            JavaConstant con = this.readValue(value, sourceFrame);
            Deoptimizer.writeValueInMaterializedObj(obj, curOffset, con, sourceFrame);
            curOffset = curOffset.add(objectLayout.sizeInBytes(kind));
            ++curIdx;
        }
        return obj;
    }

    private static JavaConstant readConstant(Pointer addr, SignedWord offset, JavaKind kind, boolean compressed, FrameInfoQueryResult frameInfo) {
        switch (kind) {
            case Boolean: {
                return JavaConstant.forBoolean((addr.readByte((WordBase)offset) != 0 ? 1 : 0) != 0);
            }
            case Byte: {
                return JavaConstant.forByte((byte)addr.readByte((WordBase)offset));
            }
            case Char: {
                return JavaConstant.forChar((char)addr.readChar((WordBase)offset));
            }
            case Short: {
                return JavaConstant.forShort((short)addr.readShort((WordBase)offset));
            }
            case Int: {
                return JavaConstant.forInt((int)addr.readInt((WordBase)offset));
            }
            case Long: {
                return JavaConstant.forLong((long)addr.readLong((WordBase)offset));
            }
            case Float: {
                return JavaConstant.forFloat((float)addr.readFloat((WordBase)offset));
            }
            case Double: {
                return JavaConstant.forDouble((double)addr.readDouble((WordBase)offset));
            }
            case Object: {
                Word p = ((Word)addr).add(offset);
                Object obj = ReferenceAccess.singleton().readObjectAt((Pointer)p, compressed);
                return SubstrateObjectConstant.forObject(obj, compressed);
            }
        }
        throw Deoptimizer.fatalDeoptimizationError("Unexpected constant kind: " + String.valueOf(kind), frameInfo);
    }
}

