/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.collections;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.util.VMError;

public final class UninterruptibleLinkedList {
    private Element head;
    private Element tail;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Element getHead() {
        return this.head;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isEmpty() {
        return this.head == null;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void append(Element sample) {
        assert (sample != null);
        assert (sample.getNext() == null);
        if (this.tail == null || this.head == null) {
            assert (this.tail == this.head);
            this.tail = sample;
            this.head = sample;
        } else {
            this.tail.setNext(sample);
            this.tail = sample;
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void remove(Element sample) {
        assert (sample != null);
        Element prev = this.findPrevious(sample);
        if (prev == null) {
            this.head = sample.getNext();
        } else {
            prev.setNext(sample.getNext());
        }
        if (this.tail == sample) {
            this.tail = prev;
        }
        sample.setNext(null);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private Element findPrevious(Element sample) {
        Element cur;
        Element prev = null;
        for (cur = this.head; cur != null && cur != sample; cur = cur.getNext()) {
            prev = cur;
        }
        VMError.guarantee(cur != null, "obj must be in the list");
        return prev;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Element pop() {
        Element result = this.head;
        this.remove(result);
        return result;
    }

    public static interface Element {
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public Element getNext();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public void setNext(Element var1);
    }
}

