/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

class CollectingObjectReferenceVisitor
implements ObjectReferenceVisitor {
    private final Pointer base;
    protected final SubstrateReferenceMap result = new SubstrateReferenceMap();

    CollectingObjectReferenceVisitor(Pointer base) {
        this.base = base;
    }

    @Override
    public void visitObjectReferences(Pointer firstObjRef, boolean compressed, int referenceSize, Object holderObject, int count) {
        Pointer pos = firstObjRef;
        Pointer end = firstObjRef.add(Word.unsigned((int)count).multiply(referenceSize));
        while (pos.belowThan((UnsignedWord)end)) {
            this.visitObjectReference(pos, compressed);
            pos = pos.add(referenceSize);
        }
    }

    private void visitObjectReference(Pointer objRef, boolean compressed) {
        int offset = NumUtil.safeToInt((long)objRef.subtract((UnsignedWord)this.base).rawValue());
        this.result.markReferenceAtOffset(offset, compressed);
    }
}

