/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.IsolateArgumentAccess;
import com.oracle.svm.core.IsolateArguments;
import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.memory.UntrackedNullableNativeMemory;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.ImageHeapList;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

@AutomaticallyRegisteredImageSingleton
public class IsolateArgumentParser {
    private final List<RuntimeOptionKey<?>> options = ImageHeapList.createGeneric(RuntimeOptionKey.class);
    private static final CGlobalData<CCharPointer> OPTION_NAMES = CGlobalDataFactory.createBytes(IsolateArgumentParser::createOptionNames);
    private static final CGlobalData<CIntPointer> OPTION_NAME_POSITIONS = CGlobalDataFactory.createBytes(IsolateArgumentParser::createOptionNamePosition);
    private static final CGlobalData<CCharPointer> OPTION_TYPES = CGlobalDataFactory.createBytes(IsolateArgumentParser::createOptionTypes);
    protected static final CGlobalData<CLongPointer> DEFAULT_VALUES = CGlobalDataFactory.createBytes(IsolateArgumentParser::createDefaultValues);
    private long[] parsedOptionValues;
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long T = 0x10000000000L;
    private boolean isCompilationIsolate;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public IsolateArgumentParser() {
    }

    @Fold
    public static IsolateArgumentParser singleton() {
        return (IsolateArgumentParser)ImageSingletons.lookup(IsolateArgumentParser.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void register(RuntimeOptionKey<?> optionKey) {
        assert (optionKey != null);
        assert (IsolateArgumentParser.singleton().parsedOptionValues == null);
        IsolateArgumentParser.singleton().options.add(optionKey);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public synchronized void sealOptions() {
        IsolateArgumentParser.singleton().parsedOptionValues = new long[IsolateArgumentParser.getOptionCount()];
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static byte[] createOptionNames() {
        StringBuilder optionNames = new StringBuilder();
        for (int i = 0; i < IsolateArgumentParser.getOptionCount(); ++i) {
            optionNames.append(IsolateArgumentParser.getOptions().get(i).getName());
            optionNames.append("\u0000");
        }
        return optionNames.toString().getBytes(StandardCharsets.ISO_8859_1);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static byte[] createOptionNamePosition() {
        byte[] result = new byte[4 * IsolateArgumentParser.getOptionCount()];
        ByteBuffer buffer = ByteBuffer.wrap(result).order(ByteOrder.nativeOrder());
        buffer.putInt(0);
        byte[] optionNames = IsolateArgumentParser.createOptionNames();
        for (int i = 0; i < optionNames.length; ++i) {
            if (optionNames[i] != 0 || i + 1 >= optionNames.length) continue;
            buffer.putInt(i + 1);
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static byte[] createOptionTypes() {
        byte[] result = new byte[1 * IsolateArgumentParser.getOptionCount()];
        ByteBuffer buffer = ByteBuffer.wrap(result).order(ByteOrder.nativeOrder());
        for (int i = 0; i < IsolateArgumentParser.getOptionCount(); ++i) {
            Class optionValueType = IsolateArgumentParser.getOptions().get(i).getDescriptor().getOptionValueType();
            buffer.put(OptionValueType.fromClass(optionValueType));
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static byte[] createDefaultValues() {
        byte[] result = new byte[8 * IsolateArgumentParser.getOptionCount()];
        ByteBuffer buffer = ByteBuffer.wrap(result).order(ByteOrder.nativeOrder());
        for (int i = 0; i < IsolateArgumentParser.getOptionCount(); ++i) {
            RuntimeOptionKey<?> option = IsolateArgumentParser.getOptions().get(i);
            VMError.guarantee(option.isIsolateCreationOnly(), "Options parsed by IsolateArgumentParser should all have the IsolateCreationOnly flag. %s doesn't", option);
            long value = IsolateArgumentParser.toLong(option.getHostedValue(), option.getDescriptor().getOptionValueType());
            buffer.putLong(value);
        }
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static long toLong(Object value, Class<?> clazz) {
        if (value == null && String.class.equals(clazz)) {
            return 0L;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw VMError.shouldNotReachHere("Unexpected option value: " + String.valueOf(value));
    }

    @Fold
    protected static List<RuntimeOptionKey<?>> getOptions() {
        return IsolateArgumentParser.singleton().options;
    }

    @Fold
    protected static int getOptionCount() {
        return IsolateArgumentParser.getOptions().size();
    }

    @Uninterruptible(reason="Still being initialized.")
    public void parse(CEntryPointCreateIsolateParameters parameters, IsolateArguments arguments) {
        this.initialize(arguments, parameters);
        if (!LibC.isSupported() || !IsolateArgumentParser.shouldParseArguments(arguments)) {
            return;
        }
        CLongPointer value = (CLongPointer)StackValue.get((int)8);
        for (int i = 1; i < arguments.getArgc(); ++i) {
            CCharPointer tail;
            CCharPointer arg = arguments.getArgv().read(i);
            if (!arg.isNonNull() || !(tail = IsolateArgumentParser.matchPrefix(arg)).isNonNull()) continue;
            CCharPointer xOptionTail = IsolateArgumentParser.matchXOption(tail);
            if (xOptionTail.isNonNull()) {
                IsolateArgumentParser.parseXOption(arguments, value, xOptionTail);
                continue;
            }
            CCharPointer xxOptionTail = IsolateArgumentParser.matchXXOption(tail);
            if (!xxOptionTail.isNonNull()) continue;
            IsolateArgumentParser.parseXXOption(arguments, value, xxOptionTail);
        }
        IsolateArgumentParser.copyStringArguments(arguments);
    }

    @Uninterruptible(reason="Tear-down in progress.")
    public boolean tearDown(IsolateArguments arguments) {
        for (int i = 0; i < IsolateArgumentParser.getOptionCount(); ++i) {
            if (OPTION_TYPES.get().read(i) != 4) continue;
            UntrackedNullableNativeMemory.free((PointerBase)IsolateArgumentAccess.readCCharPointer(arguments, i));
            IsolateArgumentAccess.writeCCharPointer(arguments, i, (CCharPointer)Word.nullPointer());
        }
        return true;
    }

    @Uninterruptible(reason="Tear-down in progress.")
    public boolean tearDown() {
        for (int i = 0; i < IsolateArgumentParser.getOptionCount(); ++i) {
            if (OPTION_TYPES.get().read(i) != 4) continue;
            UntrackedNullableNativeMemory.free(Word.pointer((long)this.parsedOptionValues[i]));
            this.parsedOptionValues[i] = 0L;
        }
        return true;
    }

    public void copyToRuntimeOptions() {
        int index = IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.ReservedAddressSpaceSize);
        long value = this.getLongOptionValue(index);
        if (DEFAULT_VALUES.get().read(index) != value) {
            SubstrateGCOptions.ReservedAddressSpaceSize.update(value);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void copyStringArguments(IsolateArguments arguments) {
        for (int i = 0; i < IsolateArgumentParser.getOptionCount(); ++i) {
            if (OPTION_TYPES.get().read(i) != 4) continue;
            CCharPointer string = IsolateArgumentAccess.readCCharPointer(arguments, i);
            if (string.isNonNull()) {
                CCharPointer copy = LibC.strdup(string);
                VMError.guarantee(copy.isNonNull(), "Copying of string argument failed.");
                IsolateArgumentAccess.writeCCharPointer(arguments, i, copy);
                continue;
            }
            IsolateArgumentAccess.writeCCharPointer(arguments, i, (CCharPointer)Word.nullPointer());
        }
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public static boolean shouldParseArguments(IsolateArguments arguments) {
        if (SubstrateOptions.ParseRuntimeOptions.getValue().booleanValue()) {
            return true;
        }
        if (RuntimeCompilation.isEnabled() && SubstrateOptions.supportCompileInIsolates()) {
            return IsolateArgumentParser.isCompilationIsolate(arguments);
        }
        return false;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    private static boolean isCompilationIsolate(IsolateArguments arguments) {
        return arguments.getIsCompilationIsolate();
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public void persistOptions(IsolateArguments arguments) {
        this.isCompilationIsolate = IsolateArgumentParser.isCompilationIsolate(arguments);
        for (int i = 0; i < IsolateArgumentParser.getOptionCount(); ++i) {
            this.parsedOptionValues[i] = IsolateArgumentAccess.readLong(arguments, i);
        }
    }

    public void verifyOptionValues() {
        for (int i = 0; i < IsolateArgumentParser.getOptionCount(); ++i) {
            RuntimeOptionKey<?> option = IsolateArgumentParser.getOptions().get(i);
            if (!IsolateArgumentParser.shouldValidate(option)) continue;
            IsolateArgumentParser.validate(option, this.getOptionValue(i));
        }
    }

    private static boolean shouldValidate(RuntimeOptionKey<?> option) {
        if (SubstrateOptions.useSerialGC()) {
            return option != SubstrateGCOptions.MinHeapSize && option != SubstrateGCOptions.MaxHeapSize && option != SubstrateGCOptions.MaxNewSize;
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isCompilationIsolate() {
        return IsolateArgumentParser.singleton().isCompilationIsolate;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean getBooleanOptionValue(int index) {
        return this.parsedOptionValues[index] == 1L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public int getIntOptionValue(int index) {
        return (int)this.parsedOptionValues[index];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getLongOptionValue(int index) {
        return this.parsedOptionValues[index];
    }

    protected CCharPointer getCCharPointerOptionValue(int index) {
        return (CCharPointer)Word.pointer((long)this.parsedOptionValues[index]);
    }

    protected Object getOptionValue(int index) {
        Class optionValueType = IsolateArgumentParser.getOptions().get(index).getDescriptor().getOptionValueType();
        long value = this.parsedOptionValues[index];
        if (optionValueType == Boolean.class) {
            assert (value == 0L || value == 1L) : value;
            return value == 1L;
        }
        if (optionValueType == Integer.class) {
            return (int)value;
        }
        if (optionValueType == Long.class) {
            return value;
        }
        if (optionValueType == String.class) {
            if (value == 0L) {
                return null;
            }
            return CTypeConversion.toJavaString((CCharPointer)((CCharPointer)Word.pointer((long)value)));
        }
        throw VMError.shouldNotReachHere("Option value has unexpected type: " + String.valueOf(optionValueType));
    }

    private static void validate(RuntimeOptionKey<?> option, Object oldValue) {
        Object newValue = option.getValue();
        if (oldValue == newValue) {
            return;
        }
        if (newValue == null || !newValue.equals(oldValue)) {
            throw new IllegalArgumentException("The option '" + option.getName() + "' can't be changed after isolate creation. Old value: " + String.valueOf(oldValue) + ", new value: " + String.valueOf(newValue));
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void initialize(IsolateArguments arguments, CEntryPointCreateIsolateParameters parameters) {
        for (int i = 0; i < IsolateArgumentParser.getOptionCount(); ++i) {
            IsolateArgumentAccess.writeLong(arguments, i, DEFAULT_VALUES.get().read(i));
        }
        if (parameters.isNonNull() && parameters.version() >= 3) {
            arguments.setArgc(parameters.getArgc());
            arguments.setArgv(parameters.getArgv());
            arguments.setProtectionKey(parameters.protectionKey());
        } else {
            arguments.setArgc(0);
            arguments.setArgv((CCharPointerPointer)Word.nullPointer());
            arguments.setProtectionKey(0);
        }
        if (parameters.isNonNull() && parameters.version() >= 5) {
            arguments.setIsCompilationIsolate(parameters.getIsCompilationIsolate());
        } else {
            arguments.setIsCompilationIsolate(false);
        }
        UnsignedWord reservedAddressSpaceSize = parameters.reservedSpaceSize();
        if (reservedAddressSpaceSize.notEqual(0)) {
            IsolateArgumentAccess.writeLong(arguments, IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.ReservedAddressSpaceSize), reservedAddressSpaceSize.rawValue());
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CCharPointer matchPrefix(CCharPointer arg) {
        if (arg.read(0) == 45) {
            return arg.addressOf(1);
        }
        return (CCharPointer)Word.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CCharPointer matchXOption(CCharPointer arg) {
        if (arg.read(0) == 88 && arg.read(1) == 109) {
            return arg.addressOf(2);
        }
        return (CCharPointer)Word.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CCharPointer matchXXOption(CCharPointer arg) {
        if (arg.read(0) == 88 && arg.read(1) == 88 && arg.read(2) == 58) {
            return arg.addressOf(3);
        }
        return (CCharPointer)Word.nullPointer();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void parseXOption(IsolateArguments arguments, CLongPointer value, CCharPointer tail) {
        byte kind = tail.read();
        if (kind == 115 && IsolateArgumentParser.parseNumericXOption(tail.addressOf(1), value)) {
            IsolateArgumentAccess.writeLong(arguments, IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.MinHeapSize), value.read());
        } else if (kind == 120 && IsolateArgumentParser.parseNumericXOption(tail.addressOf(1), value)) {
            IsolateArgumentAccess.writeLong(arguments, IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.MaxHeapSize), value.read());
        } else if (kind == 110 && IsolateArgumentParser.parseNumericXOption(tail.addressOf(1), value)) {
            IsolateArgumentAccess.writeLong(arguments, IsolateArgumentParser.getOptionIndex(SubstrateGCOptions.MaxNewSize), value.read());
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static void parseXXOption(IsolateArguments arguments, CLongPointer value, CCharPointer tail) {
        byte firstChar = tail.read();
        if (firstChar == 43 || firstChar == 45) {
            boolean booleanValue = firstChar == 43;
            for (int i = 0; i < IsolateArgumentParser.getOptionCount(); ++i) {
                int pos = OPTION_NAME_POSITIONS.get().read(i);
                CCharPointer optionName = OPTION_NAMES.get().addressOf(pos);
                if (OPTION_TYPES.get().read(i) != 1 || !IsolateArgumentParser.matches(tail.addressOf(1), optionName)) continue;
                IsolateArgumentAccess.writeBoolean(arguments, i, booleanValue);
                break;
            }
        } else {
            for (int i = 0; i < IsolateArgumentParser.getOptionCount(); ++i) {
                int pos = OPTION_NAME_POSITIONS.get().read(i);
                CCharPointer optionName = OPTION_NAMES.get().addressOf(pos);
                CCharPointer valueStart = IsolateArgumentParser.startsWith(tail, optionName);
                if (!valueStart.isNonNull() || valueStart.read() != 61) continue;
                if (OptionValueType.isNumeric(OPTION_TYPES.get().read(i))) {
                    IsolateArgumentParser.parseNumericXOption(valueStart.addressOf(1), value);
                    IsolateArgumentAccess.writeLong(arguments, i, value.read());
                } else {
                    if (OPTION_TYPES.get().read(i) != 4) continue;
                    IsolateArgumentAccess.writeCCharPointer(arguments, i, valueStart.addressOf(1));
                }
                break;
            }
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean parseNumericXOption(CCharPointer string, CLongPointer result) {
        CCharPointer pos = string;
        boolean negativeValue = false;
        if (pos.read() == 45) {
            negativeValue = true;
            pos = pos.addressOf(1);
        }
        if (!IsolateArgumentParser.atojulong(pos, result)) {
            return false;
        }
        if (negativeValue) {
            result.write(-result.read());
        }
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean atojulong(CCharPointer s, CLongPointer result) {
        long modifier;
        if (LibC.isdigit(s.read()) == 0) {
            return false;
        }
        CCharPointerPointer tailPtr = (CCharPointerPointer)StackValue.get(CCharPointer.class);
        LibC.setErrno(0);
        UnsignedWord n = LibC.strtoull(s, tailPtr, 10);
        if (LibC.errno() != 0) {
            return false;
        }
        CCharPointer tail = tailPtr.read();
        if (tail == s || LibC.strlen(tail).aboveThan(1)) {
            return false;
        }
        switch (tail.read()) {
            case 84: 
            case 116: {
                modifier = 0x10000000000L;
                break;
            }
            case 71: 
            case 103: {
                modifier = 0x40000000L;
                break;
            }
            case 77: 
            case 109: {
                modifier = 0x100000L;
                break;
            }
            case 75: 
            case 107: {
                modifier = 1024L;
                break;
            }
            case 0: {
                modifier = 1L;
                break;
            }
            default: {
                return false;
            }
        }
        UnsignedWord value = n.multiply(Word.unsigned((long)modifier));
        if (IsolateArgumentParser.checkForOverflow(value, n, modifier)) {
            return false;
        }
        result.write(value.rawValue());
        return true;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean checkForOverflow(UnsignedWord value, UnsignedWord n, long modifier) {
        return value.unsignedDivide(Word.unsigned((long)modifier)) != n;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean matches(CCharPointer input, CCharPointer expected) {
        CCharPointer tail = IsolateArgumentParser.startsWith(input, expected);
        return tail.isNonNull() && tail.read() == 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static CCharPointer startsWith(CCharPointer input, CCharPointer prefix) {
        int i = 0;
        while (prefix.read(i) != 0 && input.read(i) == prefix.read(i)) {
            ++i;
        }
        if (prefix.read(i) == 0) {
            return input.addressOf(i);
        }
        return (CCharPointer)Word.nullPointer();
    }

    @Fold
    public static int getOptionIndex(RuntimeOptionKey<?> key) {
        List<RuntimeOptionKey<?>> options = IsolateArgumentParser.getOptions();
        for (int i = 0; i < options.size(); ++i) {
            if (options.get(i) != key) continue;
            return i;
        }
        throw VMError.shouldNotReachHere("Could not find option " + key.getName() + " in the options array.");
    }

    @Fold
    public static int getParsedArgsSize() {
        return 8 * IsolateArgumentParser.getOptionCount();
    }

    protected static class OptionValueType {
        public static final byte BOOLEAN = 1;
        public static final byte INTEGER = 2;
        public static final byte LONG = 3;
        public static final byte C_CHAR_POINTER = 4;

        protected OptionValueType() {
        }

        public static byte fromClass(Class<?> c) {
            if (c == Boolean.class) {
                return 1;
            }
            if (c == Integer.class) {
                return 2;
            }
            if (c == Long.class) {
                return 3;
            }
            if (c == String.class) {
                return 4;
            }
            throw VMError.shouldNotReachHere("Option value has unexpected type: " + String.valueOf(c));
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static boolean isNumeric(byte optionValueType) {
            return optionValueType == 2 || optionValueType == 3;
        }
    }
}

