/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.image.DisallowedImageHeapObjects;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public interface ForeignSupport {
    @Fold
    public static boolean isAvailable() {
        return ImageSingletons.contains(ForeignSupport.class);
    }

    @Fold
    public static ForeignSupport singleton() {
        return (ForeignSupport)ImageSingletons.lookup(ForeignSupport.class);
    }

    public Object linkToNative(Object ... var1) throws Throwable;

    public void onMemorySegmentReachable(Object var1, DisallowedImageHeapObjects.DisallowedObjectReporter var2);

    public void onScopeReachable(Object var1, DisallowedImageHeapObjects.DisallowedObjectReporter var2);

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Scoped {
    }
}

