/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.google.common.jimfs;

import java.io.IOException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import org.graalvm.shadowed.com.google.common.base.Preconditions;
import org.graalvm.shadowed.com.google.common.collect.ImmutableMap;
import org.graalvm.shadowed.com.google.common.collect.ImmutableSet;
import org.graalvm.shadowed.com.google.common.jimfs.AbstractAttributeView;
import org.graalvm.shadowed.com.google.common.jimfs.AttributeProvider;
import org.graalvm.shadowed.com.google.common.jimfs.BasicAttributeProvider;
import org.graalvm.shadowed.com.google.common.jimfs.File;
import org.graalvm.shadowed.com.google.common.jimfs.FileLookup;
import org.jspecify.annotations.Nullable;

final class DosAttributeProvider
extends AttributeProvider {
    private static final ImmutableSet<String> ATTRIBUTES = ImmutableSet.of((Object)"readonly", (Object)"hidden", (Object)"archive", (Object)"system");
    private static final ImmutableSet<String> INHERITED_VIEWS = ImmutableSet.of((Object)"basic", (Object)"owner");

    DosAttributeProvider() {
    }

    @Override
    public String name() {
        return "dos";
    }

    @Override
    public ImmutableSet<String> inherits() {
        return INHERITED_VIEWS;
    }

    @Override
    public ImmutableSet<String> fixedAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public ImmutableMap<String, ?> defaultValues(Map<String, ?> userProvidedDefaults) {
        return ImmutableMap.of((Object)"dos:readonly", (Object)DosAttributeProvider.getDefaultValue("dos:readonly", userProvidedDefaults), (Object)"dos:hidden", (Object)DosAttributeProvider.getDefaultValue("dos:hidden", userProvidedDefaults), (Object)"dos:archive", (Object)DosAttributeProvider.getDefaultValue("dos:archive", userProvidedDefaults), (Object)"dos:system", (Object)DosAttributeProvider.getDefaultValue("dos:system", userProvidedDefaults));
    }

    private static Boolean getDefaultValue(String attribute, Map<String, ?> userProvidedDefaults) {
        Object userProvidedValue = userProvidedDefaults.get(attribute);
        if (userProvidedValue != null) {
            return DosAttributeProvider.checkType("dos", attribute, userProvidedValue, Boolean.class);
        }
        return false;
    }

    @Override
    public @Nullable Object get(File file, String attribute) {
        if (ATTRIBUTES.contains((Object)attribute)) {
            return file.getAttribute("dos", attribute);
        }
        return null;
    }

    @Override
    public void set(File file, String view, String attribute, Object value, boolean create) {
        if (this.supports(attribute)) {
            DosAttributeProvider.checkNotCreate(view, attribute, create);
            file.setAttribute("dos", attribute, DosAttributeProvider.checkType(view, attribute, value, Boolean.class));
        }
    }

    public Class<DosFileAttributeView> viewType() {
        return DosFileAttributeView.class;
    }

    @Override
    public DosFileAttributeView view(FileLookup lookup, ImmutableMap<String, FileAttributeView> inheritedViews) {
        return new View(lookup, (BasicFileAttributeView)inheritedViews.get((Object)"basic"));
    }

    public Class<DosFileAttributes> attributesType() {
        return DosFileAttributes.class;
    }

    @Override
    public DosFileAttributes readAttributes(File file) {
        return new Attributes(file);
    }

    static class Attributes
    extends BasicAttributeProvider.Attributes
    implements DosFileAttributes {
        private final boolean readOnly;
        private final boolean hidden;
        private final boolean archive;
        private final boolean system;

        protected Attributes(File file) {
            super(file);
            this.readOnly = (Boolean)file.getAttribute("dos", "readonly");
            this.hidden = (Boolean)file.getAttribute("dos", "hidden");
            this.archive = (Boolean)file.getAttribute("dos", "archive");
            this.system = (Boolean)file.getAttribute("dos", "system");
        }

        @Override
        public boolean isReadOnly() {
            return this.readOnly;
        }

        @Override
        public boolean isHidden() {
            return this.hidden;
        }

        @Override
        public boolean isArchive() {
            return this.archive;
        }

        @Override
        public boolean isSystem() {
            return this.system;
        }
    }

    private static final class View
    extends AbstractAttributeView
    implements DosFileAttributeView {
        private final BasicFileAttributeView basicView;

        public View(FileLookup lookup, BasicFileAttributeView basicView) {
            super(lookup);
            this.basicView = (BasicFileAttributeView)Preconditions.checkNotNull((Object)basicView);
        }

        @Override
        public String name() {
            return "dos";
        }

        @Override
        public DosFileAttributes readAttributes() throws IOException {
            return new Attributes(this.lookupFile());
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            this.basicView.setTimes(lastModifiedTime, lastAccessTime, createTime);
        }

        @Override
        public void setReadOnly(boolean value) throws IOException {
            this.lookupFile().setAttribute("dos", "readonly", value);
        }

        @Override
        public void setHidden(boolean value) throws IOException {
            this.lookupFile().setAttribute("dos", "hidden", value);
        }

        @Override
        public void setSystem(boolean value) throws IOException {
            this.lookupFile().setAttribute("dos", "system", value);
        }

        @Override
        public void setArchive(boolean value) throws IOException {
            this.lookupFile().setAttribute("dos", "archive", value);
        }
    }
}

