/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.TypeSymbols;
import com.oracle.svm.espresso.shared.verifier.VerifierError;

public abstract class VerificationTypeInfo {
    VerificationTypeInfo() {
    }

    public abstract int getTag();

    public int getNewOffset() {
        throw VerifierError.fatal("Asking for new offset of non Uninitialized variable verification_type_info");
    }

    public int getConstantPoolOffset() {
        throw VerifierError.fatal("Asking for CPI of non reference verification_type_info");
    }

    public String toString(ConstantPool pool) {
        switch (this.getTag()) {
            case 0: {
                return "invalid";
            }
            case 1: {
                return "int";
            }
            case 2: {
                return "float";
            }
            case 3: {
                return "double";
            }
            case 4: {
                return "long";
            }
            case 5: {
                return "null";
            }
        }
        return this.fromCP(pool);
    }

    public abstract Symbol<Type> getType(ConstantPool var1, TypeSymbols var2, BytecodeStream var3);

    public final boolean hasType() {
        return !this.isNull() && !this.isIllegal() && !this.isUninitializedThis();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isIllegal() {
        return false;
    }

    public boolean isUninitializedThis() {
        return false;
    }

    protected String fromCP(ConstantPool pool) {
        return "";
    }
}

