/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.ClassfileStream;
import com.oracle.svm.espresso.classfile.attributes.StackMapTableAttribute;
import com.oracle.svm.espresso.shared.verifier.AppendFrame;
import com.oracle.svm.espresso.shared.verifier.ChopFrame;
import com.oracle.svm.espresso.shared.verifier.FullFrame;
import com.oracle.svm.espresso.shared.verifier.MethodVerifier;
import com.oracle.svm.espresso.shared.verifier.PrimitiveTypeInfo;
import com.oracle.svm.espresso.shared.verifier.ReferenceVariable;
import com.oracle.svm.espresso.shared.verifier.SameFrame;
import com.oracle.svm.espresso.shared.verifier.SameFrameExtended;
import com.oracle.svm.espresso.shared.verifier.SameLocals1StackItemFrame;
import com.oracle.svm.espresso.shared.verifier.SameLocals1StackItemFrameExtended;
import com.oracle.svm.espresso.shared.verifier.StackMapFrame;
import com.oracle.svm.espresso.shared.verifier.UninitializedThis;
import com.oracle.svm.espresso.shared.verifier.UninitializedVariable;
import com.oracle.svm.espresso.shared.verifier.VerificationException;
import com.oracle.svm.espresso.shared.verifier.VerificationTypeInfo;

public final class StackMapFrameParser<S extends FrameState<S, B>, B extends FrameBuilder<S, B>> {
    private final B frameBuilder;
    private final ClassfileStream stream;

    public static <State extends FrameState<State, Builder>, Builder extends FrameBuilder<State, Builder>> void parse(Builder builder, StackMapTableAttribute stackMapTable, State firstFrame, int initialLastLocal) throws VerificationException {
        new StackMapFrameParser<State, Builder>(builder, stackMapTable).parseStackMapTableAttribute(firstFrame, initialLastLocal);
    }

    private StackMapFrameParser(B frameBuilder, StackMapTableAttribute stackMapTable) {
        this.frameBuilder = frameBuilder;
        this.stream = new ClassfileStream(stackMapTable.getData(), null);
    }

    private void parseStackMapTableAttribute(S firstFrame, int initialLastLocal) {
        Object previous = firstFrame;
        int bci = 0;
        boolean first = true;
        int lastLocal = initialLastLocal;
        int entryCount = this.stream.readU2();
        for (int i = 0; i < entryCount; ++i) {
            StackMapFrame entry = this.parseStackMapFrame();
            FrameAndLocalEffect<S, B> res = this.nextFrame(entry, previous, lastLocal);
            lastLocal += res.effect();
            FrameState<S, B> frame = res.state();
            bci = bci + entry.getOffset() + (first ? 0 : 1);
            this.frameBuilder.registerStackMapFrame(bci, frame);
            first = false;
            previous = frame;
        }
        if (!this.stream.isAtEndOfFile()) {
            throw MethodVerifier.failFormatNoFallback("Truncated StackMap attribute in " + this.frameBuilder.toExternalString());
        }
    }

    private FrameAndLocalEffect<S, B> nextFrame(StackMapFrame entry, S previous, int lastLocal) {
        int frameType = entry.getFrameType();
        if (frameType < 64 || frameType == 251) {
            return new FrameAndLocalEffect(previous.sameNoStack(), 0);
        }
        if (frameType < 128 || frameType == 247) {
            return new FrameAndLocalEffect(previous.sameLocalsWith1Stack(entry.getStackItem(), this.frameBuilder), 0);
        }
        if (frameType < 247) {
            throw MethodVerifier.failFormatNoFallback("Encountered reserved StackMapFrame tag: " + frameType);
        }
        if (frameType < 251) {
            return previous.chop(entry.getChopped(), lastLocal, this.frameBuilder);
        }
        if (frameType < 255) {
            return previous.append(entry.getLocals(), this.frameBuilder, lastLocal);
        }
        if (frameType == 255) {
            return this.frameBuilder.newFullFrame(entry.getStack(), entry.getLocals(), lastLocal);
        }
        throw MethodVerifier.failFormatNoFallback("Unexpected frametype byte: " + frameType);
    }

    private StackMapFrame parseStackMapFrame() {
        int frameType = this.stream.readU1();
        if (frameType < 64) {
            return new SameFrame(frameType);
        }
        if (frameType < 128) {
            VerificationTypeInfo stackItem = this.parseVerificationTypeInfo();
            return new SameLocals1StackItemFrame(frameType, stackItem);
        }
        if (frameType < 247) {
            throw MethodVerifier.failFormatNoFallback("Encountered reserved StackMapFrame tag: " + frameType);
        }
        if (frameType == 247) {
            int offsetDelta = this.stream.readU2();
            VerificationTypeInfo stackItem = this.parseVerificationTypeInfo();
            return new SameLocals1StackItemFrameExtended(frameType, offsetDelta, stackItem);
        }
        if (frameType < 251) {
            int offsetDelta = this.stream.readU2();
            return new ChopFrame(frameType, offsetDelta);
        }
        if (frameType == 251) {
            int offsetDelta = this.stream.readU2();
            return new SameFrameExtended(frameType, offsetDelta);
        }
        if (frameType < 255) {
            int offsetDelta = this.stream.readU2();
            int appendLength = frameType - 251;
            VerificationTypeInfo[] locals = new VerificationTypeInfo[appendLength];
            for (int i = 0; i < appendLength; ++i) {
                locals[i] = this.parseVerificationTypeInfo();
            }
            return new AppendFrame(frameType, offsetDelta, locals);
        }
        if (frameType == 255) {
            int offsetDelta = this.stream.readU2();
            int localsLength = this.stream.readU2();
            VerificationTypeInfo[] locals = new VerificationTypeInfo[localsLength];
            for (int i = 0; i < localsLength; ++i) {
                locals[i] = this.parseVerificationTypeInfo();
            }
            int stackLength = this.stream.readU2();
            VerificationTypeInfo[] stack = new VerificationTypeInfo[stackLength];
            for (int i = 0; i < stackLength; ++i) {
                stack[i] = this.parseVerificationTypeInfo();
            }
            return new FullFrame(frameType, offsetDelta, locals, stack);
        }
        throw MethodVerifier.failFormatNoFallback("Unrecognized StackMapFrame tag: " + frameType);
    }

    private VerificationTypeInfo parseVerificationTypeInfo() {
        int tag = this.stream.readU1();
        if (tag < 6) {
            return PrimitiveTypeInfo.get(tag);
        }
        switch (tag) {
            case 6: {
                return UninitializedThis.get();
            }
            case 7: {
                return new ReferenceVariable(this.stream.readU2());
            }
            case 8: {
                return new UninitializedVariable(this.stream.readU2());
            }
        }
        throw MethodVerifier.failFormatNoFallback("Unrecognized verification type info tag: " + tag);
    }

    public static interface FrameBuilder<S extends FrameState<S, B>, B extends FrameBuilder<S, B>> {
        public void registerStackMapFrame(int var1, S var2);

        public FrameAndLocalEffect<S, B> newFullFrame(VerificationTypeInfo[] var1, VerificationTypeInfo[] var2, int var3);

        public String toExternalString();
    }

    public static interface FrameState<S extends FrameState<S, B>, B extends FrameBuilder<S, B>> {
        public FrameState<S, B> sameNoStack();

        public FrameState<S, B> sameLocalsWith1Stack(VerificationTypeInfo var1, B var2);

        public FrameAndLocalEffect<S, B> chop(int var1, int var2, B var3);

        public FrameAndLocalEffect<S, B> append(VerificationTypeInfo[] var1, B var2, int var3);
    }

    public record FrameAndLocalEffect<S extends FrameState<S, B>, B extends FrameBuilder<S, B>>(FrameState<S, B> state, int effect) {
    }
}

