/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.JavaKind;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.shared.meta.FieldAccess;
import com.oracle.svm.espresso.shared.meta.MethodAccess;
import com.oracle.svm.espresso.shared.meta.RuntimeAccess;
import com.oracle.svm.espresso.shared.meta.TypeAccess;
import com.oracle.svm.espresso.shared.verifier.MethodVerifier;
import com.oracle.svm.espresso.shared.verifier.Operand;

class ReferenceOperand<R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>>
extends Operand<R, C, M, F> {
    protected final Symbol<Type> type;
    static final int CPI_UNKNOWN = -1;
    protected C klass = null;
    final int cpi;

    ReferenceOperand(Symbol<Type> type) {
        this(type, -1);
    }

    ReferenceOperand(Symbol<Type> type, int cpi) {
        super(JavaKind.Object);
        this.type = type;
        this.cpi = cpi;
    }

    ReferenceOperand(C klass) {
        super(JavaKind.Object);
        this.type = klass.getSymbolicType();
        this.klass = klass;
        this.cpi = -1;
    }

    @Override
    boolean isReference() {
        return true;
    }

    @Override
    Symbol<Type> getType() {
        return this.type;
    }

    @Override
    C getKlass(MethodVerifier<R, C, M, F> methodVerifier) {
        if (this.klass == null) {
            this.klass = this.getType() == methodVerifier.getThisKlass().getSymbolicType() ? methodVerifier.getThisKlass() : (this.cpi != -1 ? methodVerifier.getThisKlass().resolveClassConstantInPool(this.cpi) : methodVerifier.runtime.lookupOrLoadType(this.type, methodVerifier.getThisKlass()));
            assert (this.klass != null);
        }
        return this.klass;
    }

    @Override
    boolean compliesWith(Operand<R, C, M, F> other, MethodVerifier<R, C, M, F> methodVerifier) {
        if (other.isReference()) {
            C otherKlass;
            if (this.type == null || other.getType() == ParserSymbols.ParserTypes.java_lang_Object) {
                return true;
            }
            if (other.getType() == null) {
                return false;
            }
            if (other.getType() == this.type && ((otherKlass = ((ReferenceOperand)other).klass) == null || this.klass == null)) {
                C k;
                C c = k = this.klass == null ? otherKlass : this.klass;
                if (k == null || k.hasSameDefiningClassLoader(methodVerifier.getThisKlass())) {
                    return true;
                }
            }
            if ((otherKlass = other.getKlass(methodVerifier)).isInterface()) {
                return true;
            }
            return otherKlass.isAssignableFrom(this.getKlass(methodVerifier));
        }
        return other.isTopOperand();
    }

    @Override
    boolean compliesWithInMerge(Operand<R, C, M, F> other, MethodVerifier<R, C, M, F> methodVerifier) {
        if (other.isUninit()) {
            return false;
        }
        return this.compliesWith(other, methodVerifier);
    }

    @Override
    Operand<R, C, M, F> mergeWith(Operand<R, C, M, F> other, MethodVerifier<R, C, M, F> methodVerifier) {
        assert (!this.compliesWithInMerge(other, methodVerifier)) : "mergeWith method should only be called for non-compatible operands.";
        if (!other.isReference()) {
            return null;
        }
        if (other.isUninit()) {
            return null;
        }
        if (other.isArrayType()) {
            return methodVerifier.jlObject;
        }
        if (other.isNull()) {
            return this;
        }
        C result = this.getKlass(methodVerifier).findLeastCommonAncestor(other.getKlass(methodVerifier));
        return result == null ? null : new ReferenceOperand<R, C, M, F>(result);
    }

    public String toString() {
        return this.type == null ? "null" : this.type.toString();
    }
}

