/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.bytecode.BytecodeStream;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.TypeSymbols;
import com.oracle.svm.espresso.shared.verifier.VerificationTypeInfo;
import com.oracle.svm.espresso.shared.verifier.VerifierError;

final class PrimitiveTypeInfo
extends VerificationTypeInfo {
    private static final PrimitiveTypeInfo Bogus = new PrimitiveTypeInfo(0);
    private static final PrimitiveTypeInfo Integer = new PrimitiveTypeInfo(1);
    private static final PrimitiveTypeInfo Float = new PrimitiveTypeInfo(2);
    private static final PrimitiveTypeInfo Double = new PrimitiveTypeInfo(3);
    private static final PrimitiveTypeInfo Long = new PrimitiveTypeInfo(4);
    private static final PrimitiveTypeInfo Null = new PrimitiveTypeInfo(5);
    private final int tag;

    private PrimitiveTypeInfo(int tag) {
        if (tag < 0 || tag > 5) {
            VerifierError.fatal("Not a primitive verification type info tag: " + tag);
        }
        this.tag = tag;
    }

    @Override
    public int getTag() {
        return this.tag;
    }

    static VerificationTypeInfo get(int tag) {
        switch (tag) {
            case 0: {
                return Bogus;
            }
            case 1: {
                return Integer;
            }
            case 2: {
                return Float;
            }
            case 3: {
                return Double;
            }
            case 4: {
                return Long;
            }
            case 5: {
                return Null;
            }
        }
        throw VerifierError.fatal("Unrecognized VerificationTypeInfo tag: " + tag);
    }

    @Override
    public Symbol<Type> getType(ConstantPool pool, TypeSymbols types, BytecodeStream bs) {
        switch (this.tag) {
            case 1: {
                return ParserSymbols.ParserTypes._int;
            }
            case 2: {
                return ParserSymbols.ParserTypes._float;
            }
            case 3: {
                return ParserSymbols.ParserTypes._double;
            }
            case 4: {
                return ParserSymbols.ParserTypes._long;
            }
        }
        throw VerifierError.fatal("'getType' was called Null or Invalid type info.");
    }

    @Override
    public boolean isNull() {
        return this.tag == 5;
    }

    @Override
    public boolean isIllegal() {
        return this.tag == 0;
    }
}

