/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.JavaKind;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.shared.meta.FieldAccess;
import com.oracle.svm.espresso.shared.meta.MethodAccess;
import com.oracle.svm.espresso.shared.meta.RuntimeAccess;
import com.oracle.svm.espresso.shared.meta.TypeAccess;
import com.oracle.svm.espresso.shared.verifier.MethodVerifier;
import com.oracle.svm.espresso.shared.verifier.VerifierError;

abstract class Operand<R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> {
    private static final Operand[] EMPTY_ARRAY = new Operand[0];
    protected final JavaKind kind;

    public static <R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> Operand<R, C, M, F>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    Operand(JavaKind kind) {
        this.kind = kind;
    }

    final boolean isTopOperand() {
        return this.kind == JavaKind.Illegal;
    }

    final JavaKind getKind() {
        return this.kind;
    }

    final int slots() {
        return this.isType2() ? 2 : 1;
    }

    final boolean isType2() {
        return this.kind == JavaKind.Long || this.kind == JavaKind.Double;
    }

    boolean isArrayType() {
        return false;
    }

    boolean isReference() {
        return false;
    }

    boolean isPrimitive() {
        return false;
    }

    boolean isReturnAddress() {
        return false;
    }

    Operand<R, C, M, F> getComponent() {
        throw VerifierError.fatal("Calling getComponent of a non-array Operand");
    }

    Operand<R, C, M, F> getElemental() {
        throw VerifierError.fatal("Calling getElemental of a non-array Operand");
    }

    int getDimensions() {
        throw VerifierError.fatal("Calling getDimensions of a non-array Operand");
    }

    Symbol<Type> getType() {
        return null;
    }

    C getKlass(MethodVerifier<R, C, M, F> methodVerifier) {
        return null;
    }

    boolean isUninit() {
        return false;
    }

    boolean isUninitThis() {
        return false;
    }

    boolean isNull() {
        return false;
    }

    abstract boolean compliesWith(Operand<R, C, M, F> var1, MethodVerifier<R, C, M, F> var2);

    boolean compliesWithInMerge(Operand<R, C, M, F> other, MethodVerifier<R, C, M, F> methodVerifier) {
        return this.compliesWith(other, methodVerifier);
    }

    abstract Operand<R, C, M, F> mergeWith(Operand<R, C, M, F> var1, MethodVerifier<R, C, M, F> var2);
}

