/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.tables;

import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.tables.EntryTable;
import java.util.ArrayList;
import java.util.concurrent.locks.ReadWriteLock;

public abstract class AbstractModuleTable<M, ME extends AbstractModuleEntry<M>>
extends EntryTable<ME, ModuleData<M>> {
    public AbstractModuleTable(ReadWriteLock lock) {
        super(lock);
    }

    public ME createAndAddEntry(Symbol<Name> name, String version, String location, boolean isOpen, M module) {
        return (ME)((AbstractModuleEntry)this.createAndAddEntry(name, new ModuleData<M>(version, location, module, isOpen)));
    }

    public ME createUnnamedModuleEntry(M module) {
        AbstractModuleEntry result = (AbstractModuleEntry)this.createEntry(null, new ModuleData<M>(null, null, module, true));
        result.setCanReadAllUnnamed();
        return (ME)result;
    }

    public static final class ModuleData<M> {
        private final String version;
        private final String location;
        private final boolean isOpen;
        private final M module;

        public ModuleData(String version, String location, M module, boolean isOpen) {
            this.version = version;
            this.location = location;
            this.isOpen = isOpen;
            this.module = module;
        }
    }

    public static abstract class AbstractModuleEntry<M>
    extends EntryTable.NamedEntry {
        private final boolean isOpen;
        private M module;
        private String version;
        private String location;
        private boolean canReadAllUnnamed;
        private ArrayList<AbstractModuleEntry<M>> reads;
        private volatile boolean hasDefaultReads;

        protected AbstractModuleEntry(Symbol<Name> name, ModuleData<M> data) {
            super(name);
            this.version = data.version;
            this.location = data.location;
            this.isOpen = data.isOpen;
            this.module = data.module;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addReads(AbstractModuleEntry<M> from) {
            if (!this.isNamed()) {
                return;
            }
            AbstractModuleEntry abstractModuleEntry = this;
            synchronized (abstractModuleEntry) {
                if (from == null) {
                    this.setCanReadAllUnnamed();
                    return;
                }
                if (this.reads == null) {
                    this.reads = new ArrayList();
                }
                if (!this.contains(from)) {
                    this.reads.add(from);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean canRead(AbstractModuleEntry<M> m, boolean mIsJavaBase) {
            if (!this.isNamed() || mIsJavaBase) {
                return true;
            }
            if (!m.isNamed() && this.canReadAllUnnamed) {
                return true;
            }
            AbstractModuleEntry abstractModuleEntry = this;
            synchronized (abstractModuleEntry) {
                if (this.hasReads()) {
                    return this.contains(m);
                }
                return false;
            }
        }

        private boolean contains(AbstractModuleEntry<M> from) {
            return this.reads.contains(from);
        }

        public void setModule(M module) {
            assert (this.module == null);
            this.module = module;
        }

        public M module() {
            return this.module;
        }

        public String version() {
            return this.version;
        }

        public String location() {
            return this.location;
        }

        public void setCanReadAllUnnamed() {
            this.canReadAllUnnamed = true;
        }

        public boolean hasDefaultReads() {
            return this.hasDefaultReads;
        }

        public void setHasDefaultReads() {
            this.hasDefaultReads = true;
        }

        public boolean isOpen() {
            return this.isOpen;
        }

        public boolean isNamed() {
            return this.getName() != null;
        }

        public boolean hasReads() {
            return this.reads != null && !this.reads.isEmpty();
        }

        public void setVersionAndLocation(String moduleVersion, String moduleLocation) {
            assert (this.version == null && this.location == null);
            this.version = moduleVersion;
            this.location = moduleLocation;
        }
    }
}

