/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.descriptors;

import com.oracle.svm.espresso.classfile.descriptors.ByteSequence;
import com.oracle.svm.espresso.classfile.descriptors.ModifiedUTF8;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;

public final class Validation {
    private static final int INVALID_SIGNATURE = -1;

    private Validation() {
    }

    public static boolean validUnqualifiedName(ByteSequence bytes) {
        if (bytes.length() == 0) {
            return false;
        }
        if (bytes.byteAt(0) == 40) {
            return false;
        }
        for (int i = 0; i < bytes.length(); ++i) {
            char ch = (char)bytes.byteAt(i);
            if (!Validation.invalidUnqualifiedNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean validUnqualifiedName(CharSequence chars) {
        if (chars.length() == 0) {
            return false;
        }
        if (chars.charAt(0) == '(') {
            return false;
        }
        for (int i = 0; i < chars.length(); ++i) {
            char ch = chars.charAt(i);
            if (!Validation.invalidUnqualifiedNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean invalidUnqualifiedNameChar(char ch) {
        switch (ch) {
            case '.': 
            case '/': 
            case ';': 
            case '[': {
                return true;
            }
        }
        return false;
    }

    public static boolean validMethodName(ByteSequence bytes) {
        if (bytes.length() == 0) {
            return false;
        }
        char first = (char)bytes.byteAt(0);
        if (first == '<') {
            return bytes.contentEquals(ParserSymbols.ParserNames._init_) || bytes.contentEquals(ParserSymbols.ParserNames._clinit_);
        }
        for (int i = 0; i < bytes.length(); ++i) {
            char ch = (char)bytes.byteAt(i);
            if (!Validation.invalidMethodNameChar(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean invalidMethodNameChar(char ch) {
        switch (ch) {
            case '.': 
            case '/': 
            case ';': 
            case '<': 
            case '>': 
            case '[': {
                return true;
            }
        }
        return false;
    }

    public static boolean validBinaryName(ByteSequence bytes) {
        if (bytes.length() == 0) {
            return false;
        }
        if (bytes.byteAt(0) == 47) {
            return false;
        }
        int prev = 0;
        for (int i = 0; i < bytes.length(); ++i) {
            while (i < bytes.length() && bytes.byteAt(i) != 47) {
                ++i;
            }
            if (!Validation.validUnqualifiedName(bytes.subSequence(prev, i))) {
                return false;
            }
            prev = i + 1;
        }
        return prev != bytes.length();
    }

    public static boolean validBinaryName(CharSequence chars) {
        if (chars.length() == 0) {
            return false;
        }
        if (chars.charAt(0) == '/') {
            return false;
        }
        int prev = 0;
        for (int i = 0; i < chars.length(); ++i) {
            while (i < chars.length() && chars.charAt(i) != '/') {
                ++i;
            }
            if (!Validation.validUnqualifiedName(chars.subSequence(prev, i))) {
                return false;
            }
            prev = i + 1;
        }
        return prev != chars.length();
    }

    public static boolean validClassNameEntry(ByteSequence bytes) {
        if (bytes.length() == 0) {
            return false;
        }
        if (bytes.byteAt(0) == 91) {
            return Validation.validTypeDescriptor(bytes, false);
        }
        return Validation.validBinaryName(bytes);
    }

    public static boolean validFieldDescriptor(ByteSequence bytes) {
        return Validation.validTypeDescriptor(bytes, false);
    }

    public static boolean validTypeDescriptor(ByteSequence bytes, boolean allowVoid) {
        if (bytes.length() == 0) {
            return false;
        }
        byte first = bytes.byteAt(0);
        if (bytes.length() == 1) {
            return first == 86 && allowVoid || Validation.validPrimitiveChar(first);
        }
        if (first == 91) {
            int dimensions;
            for (dimensions = 0; dimensions < bytes.length() && bytes.byteAt(dimensions) == 91; ++dimensions) {
            }
            if (dimensions > 255) {
                return false;
            }
            return Validation.validFieldDescriptor(bytes.subSequence(dimensions));
        }
        if (first == 76) {
            char last = (char)bytes.byteAt(bytes.length() - 1);
            if (last != ';') {
                return false;
            }
            return Validation.validBinaryName(bytes.subSequence(1, bytes.length() - 1));
        }
        return false;
    }

    public static boolean validSignatureDescriptor(ByteSequence bytes) {
        return Validation.validSignatureDescriptorGetSlots(bytes) >= 0;
    }

    public static int validSignatureDescriptorGetSlots(ByteSequence bytes) {
        if (bytes.length() < 3) {
            return -1;
        }
        if (bytes.byteAt(0) != 40) {
            return -1;
        }
        int slots = 0;
        int currentSlot = -1;
        int index = 1;
        while (index < bytes.length() && bytes.byteAt(index) != 41) {
            int prev = index;
            while (index < bytes.length() && bytes.byteAt(index) == 91) {
                ++index;
            }
            int dimensions = index - prev;
            if (dimensions > 255) {
                return -1;
            }
            if (index >= bytes.length()) {
                return -1;
            }
            if (dimensions > 0) {
                currentSlot = 1;
            }
            if (bytes.byteAt(index) == 76) {
                ++index;
                while (index < bytes.length() && bytes.byteAt(index) != 59) {
                    ++index;
                }
                if (index >= bytes.length()) {
                    return -1;
                }
                assert (bytes.byteAt(index) == 59);
                if (!Validation.validFieldDescriptor(bytes.subSequence(prev, index + 1))) {
                    return -1;
                }
                ++index;
                currentSlot = 1;
            } else {
                byte ch = bytes.byteAt(index);
                if (!Validation.validPrimitiveChar(ch)) {
                    return -1;
                }
                if (currentSlot <= 0) {
                    currentSlot = ch == 68 || ch == 74 ? 2 : 1;
                }
                ++index;
            }
            assert (currentSlot > 0);
            slots += currentSlot;
            currentSlot = -1;
        }
        if (index >= bytes.length()) {
            return -1;
        }
        assert (bytes.byteAt(index) == 41);
        return Validation.validTypeDescriptor(bytes.subSequence(index + 1), true) ? slots : -1;
    }

    private static boolean validPrimitiveChar(byte ch) {
        switch (ch) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: {
                return true;
            }
        }
        return false;
    }

    public static boolean validModifiedUTF8(ByteSequence bytes) {
        return ModifiedUTF8.isValid(bytes.getUnderlyingBytes(), bytes.offset(), bytes.length());
    }

    public static boolean validPackageName(ByteSequence bytes) {
        return Validation.validDotQualifiedName(bytes);
    }

    public static boolean validModuleName(ByteSequence bytes) {
        return Validation.validDotQualifiedName(bytes);
    }

    private static boolean validDotQualifiedName(ByteSequence bytes) {
        if (bytes.length() == 0) {
            return false;
        }
        if (bytes.byteAt(0) == 46) {
            return false;
        }
        int prev = 0;
        for (int i = 0; i < bytes.length(); ++i) {
            while (i < bytes.length() && bytes.byteAt(i) != 46) {
                ++i;
            }
            if (!Validation.validUnqualifiedName(bytes.subSequence(prev, i))) {
                return false;
            }
            prev = i + 1;
        }
        return prev != bytes.length();
    }
}

