/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.descriptors;

import com.oracle.svm.espresso.classfile.descriptors.ByteSequence;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Symbols;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;

final class SymbolsImpl
extends Symbols {
    private final ConcurrentHashMap<ByteSequence, Symbol<?>> strongMap;
    private final WeakHashMap<ByteSequence, WeakReference<Symbol<?>>> weakMap;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    SymbolsImpl(int initialStrongSize, int initialWeakSize) {
        this.strongMap = initialWeakSize > 0 ? new ConcurrentHashMap(initialStrongSize) : new ConcurrentHashMap();
        this.weakMap = initialWeakSize > 0 ? new WeakHashMap(initialWeakSize) : new WeakHashMap();
    }

    SymbolsImpl(Set<Symbol<?>> existingSymbols, int initialStrongSize, int initialWeakSize) {
        this(initialStrongSize, initialWeakSize);
        for (Symbol<?> symbol : existingSymbols) {
            this.strongMap.put(symbol, symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> Symbol<T> lookup(ByteSequence byteSequence) {
        Symbol<?> result = this.strongMap.get(byteSequence);
        if (result != null) {
            return result;
        }
        this.readWriteLock.readLock().lock();
        try {
            result = this.strongMap.get(byteSequence);
            if (result != null) {
                Symbol<?> symbol = result;
                return symbol;
            }
            WeakReference<Symbol<?>> weakValue = this.weakMap.get(byteSequence);
            if (weakValue != null) {
                Symbol symbol = (Symbol)weakValue.get();
                return symbol;
            }
            Symbol<T> symbol = null;
            return symbol;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> Symbol<T> getOrCreate(ByteSequence byteSequence, boolean ensureStrongReference) {
        Symbol symbol = this.strongMap.get(byteSequence);
        if (symbol != null) {
            return symbol;
        }
        this.readWriteLock.writeLock().lock();
        try {
            symbol = this.strongMap.get(byteSequence);
            if (symbol != null) {
                Symbol symbol2 = symbol;
                return symbol2;
            }
            if (ensureStrongReference) {
                WeakReference<Symbol<?>> weakValue = this.weakMap.remove(byteSequence);
                if (weakValue != null && (symbol = (Symbol)weakValue.get()) != null) {
                    this.strongMap.put(symbol, symbol);
                    Symbol symbol3 = symbol;
                    return symbol3;
                }
                symbol = SymbolsImpl.createSymbolInstanceUnsafe(byteSequence);
                this.strongMap.put(symbol, symbol);
                Symbol symbol4 = symbol;
                return symbol4;
            }
            WeakReference<Symbol<?>> weakValue = this.weakMap.get(byteSequence);
            if (weakValue != null && (symbol = (Symbol)weakValue.get()) != null) {
                Symbol symbol5 = symbol;
                return symbol5;
            }
            symbol = SymbolsImpl.createSymbolInstanceUnsafe(byteSequence);
            this.weakMap.put(symbol, new WeakReference(symbol));
            Symbol symbol6 = symbol;
            return symbol6;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    boolean isWeak(Symbol<?> symbol) {
        assert (this.lookup(symbol) == symbol);
        return !this.strongMap.containsKey(symbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    boolean verify() {
        this.readWriteLock.writeLock().lock();
        try {
            weakKeys = this.weakMap.keySet();
            strongKeys = this.strongMap.keySet();
            if (!weakKeys.stream().allMatch((Predicate<ByteSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$verify$0(com.oracle.svm.espresso.classfile.descriptors.ByteSequence ), (Lcom/oracle/svm/espresso/classfile/descriptors/ByteSequence;)Z)()) || !strongKeys.stream().allMatch((Predicate<ByteSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$verify$1(com.oracle.svm.espresso.classfile.descriptors.ByteSequence ), (Lcom/oracle/svm/espresso/classfile/descriptors/ByteSequence;)Z)())) ** GOTO lbl-1000
            if (!weakKeys.stream().noneMatch((Predicate<ByteSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, containsKey(java.lang.Object ), (Lcom/oracle/svm/espresso/classfile/descriptors/ByteSequence;)Z)(this.strongMap))) ** GOTO lbl-1000
            if (strongKeys.stream().noneMatch((Predicate<ByteSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, containsKey(java.lang.Object ), (Lcom/oracle/svm/espresso/classfile/descriptors/ByteSequence;)Z)(this.weakMap)) && weakKeys.stream().allMatch((Predicate<ByteSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$verify$2(com.oracle.svm.espresso.classfile.descriptors.ByteSequence ), (Lcom/oracle/svm/espresso/classfile/descriptors/ByteSequence;)Z)((SymbolsImpl)this)) && strongKeys.stream().allMatch((Predicate<ByteSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$verify$3(com.oracle.svm.espresso.classfile.descriptors.ByteSequence ), (Lcom/oracle/svm/espresso/classfile/descriptors/ByteSequence;)Z)((SymbolsImpl)this)) && weakKeys.stream().allMatch((Predicate<ByteSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$verify$4(com.oracle.svm.espresso.classfile.descriptors.ByteSequence ), (Lcom/oracle/svm/espresso/classfile/descriptors/ByteSequence;)Z)((SymbolsImpl)this)) && strongKeys.stream().noneMatch((Predicate<ByteSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$verify$5(com.oracle.svm.espresso.classfile.descriptors.ByteSequence ), (Lcom/oracle/svm/espresso/classfile/descriptors/ByteSequence;)Z)((SymbolsImpl)this))) {
                v0 = true;
            } else lbl-1000:
            // 3 sources

            {
                v0 = false;
            }
            var3_3 = v0;
            return var3_3;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private /* synthetic */ boolean lambda$verify$5(ByteSequence key) {
        return this.isWeak((Symbol)key);
    }

    private /* synthetic */ boolean lambda$verify$4(ByteSequence key) {
        return this.isWeak((Symbol)key);
    }

    private /* synthetic */ boolean lambda$verify$3(ByteSequence key) {
        return key == this.strongMap.get(key);
    }

    private /* synthetic */ boolean lambda$verify$2(ByteSequence key) {
        return key == this.weakMap.get(key).get();
    }

    private static /* synthetic */ boolean lambda$verify$1(ByteSequence key) {
        return key instanceof Symbol;
    }

    private static /* synthetic */ boolean lambda$verify$0(ByteSequence key) {
        return key instanceof Symbol;
    }
}

