/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.ConstantPool;
import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;

public final class ConstantValueAttribute
extends Attribute {
    public static final Symbol<Name> NAME = ParserSymbols.ParserNames.ConstantValue;
    private final char constantValueIndex;

    public ConstantValueAttribute(int constantValueIndex) {
        this.constantValueIndex = (char)constantValueIndex;
    }

    public int getConstantValueIndex() {
        return this.constantValueIndex;
    }

    @Override
    public boolean isSame(Attribute other, ConstantPool thisPool, ConstantPool otherPool) {
        if (!super.isSame(other, thisPool, otherPool)) {
            return false;
        }
        ConstantValueAttribute that = (ConstantValueAttribute)other;
        return thisPool.isSame(this.constantValueIndex, that.constantValueIndex, otherPool);
    }

    @Override
    public Symbol<Name> getName() {
        return NAME;
    }
}

