/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile;

import com.oracle.svm.espresso.classfile.ParserConstantPool;
import com.oracle.svm.espresso.classfile.descriptors.Descriptor;
import com.oracle.svm.espresso.classfile.descriptors.ModifiedUTF8;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Signature;
import com.oracle.svm.espresso.classfile.descriptors.SignatureSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.classfile.descriptors.Type;
import com.oracle.svm.espresso.classfile.descriptors.Validation;
import com.oracle.svm.espresso.classfile.descriptors.ValidationException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Formatter;

public abstract class ConstantPool {
    public static final byte CONSTANT_Invalid = 0;
    public static final byte CONSTANT_Utf8 = 1;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_NameAndType = 12;
    public static final byte CONSTANT_MethodHandle = 15;
    public static final byte CONSTANT_MethodType = 16;
    public static final byte CONSTANT_Dynamic = 17;
    public static final byte CONSTANT_InvokeDynamic = 18;
    public static final byte CONSTANT_Module = 19;
    public static final byte CONSTANT_Package = 20;
    protected final byte[] tags;
    protected final int[] entries;
    protected final Symbol<?>[] symbols;
    protected final char majorVersion;
    protected final char minorVersion;
    private boolean validated;

    protected ConstantPool(byte[] tags, int[] entries, Symbol<?>[] symbols, int majorVersion, int minorVersion) {
        assert (tags.length == entries.length);
        this.tags = tags;
        this.entries = entries;
        this.symbols = symbols;
        this.majorVersion = (char)majorVersion;
        this.minorVersion = (char)minorVersion;
    }

    protected ConstantPool(ParserConstantPool parserConstantPool) {
        this(parserConstantPool.tags, parserConstantPool.entries, parserConstantPool.symbols, parserConstantPool.getMajorVersion(), parserConstantPool.getMinorVersion());
    }

    public abstract RuntimeException classFormatError(String var1);

    public abstract ParserConstantPool getParserConstantPool();

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int length() {
        return this.entries.length;
    }

    public int intAt(int index) {
        this.checkTag(index, (byte)3);
        return this.entries[index];
    }

    public float floatAt(int index) {
        this.checkTag(index, (byte)4);
        return Float.intBitsToFloat(this.entries[index]);
    }

    public long longAt(int index) {
        this.checkTag(index, (byte)5);
        assert (this.byteTagAt(index + 1) == 0);
        long hiBytes = this.entries[index];
        long loBytes = this.entries[index + 1];
        return hiBytes << 32 | loBytes & 0xFFFFFFFFL;
    }

    public double doubleAt(int index) {
        this.checkTag(index, (byte)6);
        assert (this.byteTagAt(index + 1) == 0);
        long hiBytes = this.entries[index];
        long loBytes = this.entries[index + 1];
        long rawBits = hiBytes << 32 | loBytes & 0xFFFFFFFFL;
        return Double.longBitsToDouble(rawBits);
    }

    protected RuntimeException constantPoolIndexOutOfBounds(int index, String description) {
        throw this.classFormatError("Constant pool index (" + index + ")" + (String)(description == null ? "" : " for " + description) + " is out of range");
    }

    protected byte byteTagAt(int index) {
        if (0 <= index && index < this.tags.length) {
            return this.tags[index];
        }
        throw this.constantPoolIndexOutOfBounds(index, null);
    }

    public Tag tagAt(int index) {
        byte byteTag = this.byteTagAt(index);
        if (byteTag == 0) {
            return Tag.INVALID;
        }
        Tag tag = Tag.fromValue(byteTag);
        if (tag == null) {
            throw this.unexpectedEntry(index, "invalid tag", new Tag[0]);
        }
        return tag;
    }

    protected RuntimeException unexpectedEntry(int index, Tag tag, String description, Tag ... expected) {
        throw this.classFormatError("Constant pool entry" + (String)(description == null ? "" : " for " + description) + " at " + index + " is a " + String.valueOf((Object)tag) + ", expected " + Arrays.toString((Object[])expected));
    }

    protected RuntimeException unexpectedEntry(int index, String description, Tag ... expected) {
        throw this.unexpectedEntry(index, this.tagAt(index), description, expected);
    }

    private void checkTag(int index, byte expectedTag) {
        byte tag = this.byteTagAt(index);
        if (tag != expectedTag) {
            throw this.unexpectedEntry(index, Tag.fromValue(tag), null, Tag.fromValue(expectedTag));
        }
    }

    private void checkMemberTag(int index) {
        byte tag = this.byteTagAt(index);
        if (tag != 9 && tag != 10 && tag != 11) {
            throw this.unexpectedEntry(index, Tag.fromValue(tag), null, Tag.FIELD_REF, Tag.METHOD_REF, Tag.INTERFACE_METHOD_REF);
        }
    }

    private void checkBSMTag(int index) {
        byte tag = this.byteTagAt(index);
        if (tag != 18 && tag != 17) {
            throw this.unexpectedEntry(index, Tag.fromValue(tag), null, Tag.INVOKEDYNAMIC, Tag.DYNAMIC);
        }
    }

    private void checkMethodTag(int methodIndex) {
        byte tag = this.byteTagAt(methodIndex);
        if (tag != 10 && tag != 11) {
            throw this.unexpectedEntry(methodIndex, Tag.fromValue(tag), null, Tag.METHOD_REF, Tag.INTERFACE_METHOD_REF);
        }
    }

    protected <T extends ModifiedUTF8> Symbol<T> unsafeUtf8At(int utf8Index) {
        return this.utf8At(utf8Index);
    }

    public Symbol<?> utf8At(int utf8Index) {
        return this.utf8At(utf8Index, null);
    }

    public Symbol<?> utf8At(int utf8Index, String description) {
        this.checkTag(utf8Index, (byte)1);
        int symbolIndex = this.symbolEntryIndex(utf8Index);
        if (0 <= symbolIndex && symbolIndex < this.tags.length) {
            return this.symbols[symbolIndex];
        }
        throw this.classFormatError(description);
    }

    public String toString(int index) {
        return switch (this.tagAt(index).ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> null;
            case 1 -> this.utf8At(index).toString();
            case 2 -> Integer.toString(this.intAt(index));
            case 3 -> Float.toString(this.floatAt(index));
            case 4 -> Long.toString(this.longAt(index));
            case 5 -> Double.toString(this.doubleAt(index));
            case 6 -> this.className(index).toString();
            case 7 -> this.utf8At(this.stringUtf8Index(index)).toString();
            case 8, 9, 10 -> String.valueOf(this.className(this.memberClassIndex(index))) + "." + this.toString(this.memberNameAndTypeIndex(index));
            case 11 -> String.valueOf(this.utf8At(this.nameAndTypeNameIndex(index))) + ":" + String.valueOf(this.utf8At(this.nameAndTypeDescriptorIndex(index)));
            case 14, 15 -> "#" + this.bsmBootstrapMethodAttrIndex(index) + " " + String.valueOf(this.bsmName(index)) + ":" + String.valueOf(this.bsmDescriptor(index));
            case 16 -> this.toString(this.moduleNameIndex(index));
            case 17 -> this.toString(this.packageNameIndex(index));
            case 12 -> this.methodHandleRefKind(index) + " " + this.toString(this.methodHandleMemberIndex(index));
            case 13 -> this.toString(this.methodTypeDescriptorIndex(index));
        };
    }

    protected int classNameIndex(int classIndex) {
        this.checkTag(classIndex, (byte)7);
        int nameIndex = this.entries[classIndex] & 0xFFFF;
        return nameIndex;
    }

    public Symbol<Name> className(int classIndex) {
        this.checkTag(classIndex, (byte)7);
        int nameIndex = this.entries[classIndex] & 0xFFFF;
        Symbol<Name> name = this.unsafeUtf8At(nameIndex);
        assert (!this.validated || Validation.validClassNameEntry(name));
        return name;
    }

    private int symbolEntryIndex(int utf8Index) {
        this.checkTag(utf8Index, (byte)1);
        int symbolIndex = this.entries[utf8Index] & 0xFFFF;
        return symbolIndex;
    }

    protected int stringUtf8Index(int stringIndex) {
        this.checkTag(stringIndex, (byte)8);
        int utf8Index = this.entries[stringIndex] & 0xFFFF;
        return utf8Index;
    }

    public int methodHandleRefKind(int methodHandleIndex) {
        this.checkTag(methodHandleIndex, (byte)15);
        int refKind = this.entries[methodHandleIndex] >>> 16;
        assert (!this.validated || 0 < refKind && refKind < 10);
        return refKind;
    }

    protected int methodHandleMemberIndex(int methodHandleIndex) {
        this.checkTag(methodHandleIndex, (byte)15);
        int memberIndex = this.entries[methodHandleIndex] & 0xFFFF;
        return memberIndex;
    }

    protected int methodTypeDescriptorIndex(int methodTypeIndex) {
        this.checkTag(methodTypeIndex, (byte)16);
        int descriptorIndex = this.entries[methodTypeIndex] & 0xFFFF;
        return descriptorIndex;
    }

    public Symbol<Signature> methodTypeSignature(int methodTypeIndex) {
        this.checkTag(methodTypeIndex, (byte)16);
        Symbol<Signature> signature = this.utf8At(this.methodTypeDescriptorIndex(methodTypeIndex));
        assert (!this.validated || Validation.validSignatureDescriptor(signature));
        return signature;
    }

    protected int invokeDynamicBootstrapMethodAttrIndex(int invokeDynamicIndex) {
        this.checkTag(invokeDynamicIndex, (byte)18);
        int bootstrapMethodAttrIndex = this.entries[invokeDynamicIndex] >>> 16;
        return bootstrapMethodAttrIndex;
    }

    protected int invokeDynamicNameAndTypeIndex(int invokeDynamicIndex) {
        this.checkTag(invokeDynamicIndex, (byte)18);
        int nameAndTypeIndex = this.entries[invokeDynamicIndex] & 0xFFFF;
        return nameAndTypeIndex;
    }

    public Symbol<Name> invokeDynamicName(int invokeDynamicIndex) {
        this.checkTag(invokeDynamicIndex, (byte)18);
        int nameAndTypeIndex = this.invokeDynamicNameAndTypeIndex(invokeDynamicIndex);
        return this.unsafeUtf8At(this.nameAndTypeNameIndex(nameAndTypeIndex));
    }

    public Symbol<Signature> invokeDynamicSignature(int invokeDynamicIndex) {
        this.checkTag(invokeDynamicIndex, (byte)18);
        int nameAndTypeIndex = this.invokeDynamicNameAndTypeIndex(invokeDynamicIndex);
        Symbol<Signature> signature = this.unsafeUtf8At(this.nameAndTypeDescriptorIndex(nameAndTypeIndex));
        assert (!this.validated || Validation.validSignatureDescriptor(signature));
        return signature;
    }

    protected int bsmNameAndTypeIndex(int bsmIndex) {
        this.checkBSMTag(bsmIndex);
        int nameAndTypeIndex = this.entries[bsmIndex] & 0xFFFF;
        return nameAndTypeIndex;
    }

    public Symbol<Name> bsmName(int bsmIndex) {
        this.checkBSMTag(bsmIndex);
        int nameAndTypeIndex = this.bsmNameAndTypeIndex(bsmIndex);
        return this.unsafeUtf8At(this.nameAndTypeNameIndex(nameAndTypeIndex));
    }

    public Symbol<? extends Descriptor> bsmDescriptor(int bsmIndex) {
        this.checkBSMTag(bsmIndex);
        int nameAndTypeIndex = this.bsmNameAndTypeIndex(bsmIndex);
        return this.unsafeUtf8At(this.nameAndTypeDescriptorIndex(nameAndTypeIndex));
    }

    protected int dynamicBootstrapMethodAttrIndex(int dynamicIndex) {
        this.checkTag(dynamicIndex, (byte)17);
        int bootstrapMethodAttrIndex = this.entries[dynamicIndex] >>> 16;
        return bootstrapMethodAttrIndex;
    }

    public int bsmBootstrapMethodAttrIndex(int bsmIndex) {
        this.checkBSMTag(bsmIndex);
        int bootstrapMethodAttrIndex = this.entries[bsmIndex] >>> 16;
        return bootstrapMethodAttrIndex;
    }

    protected int dynamicNameAndTypeIndex(int dynamicIndex) {
        this.checkTag(dynamicIndex, (byte)17);
        int nameAndTypeIndex = this.entries[dynamicIndex] & 0xFFFF;
        return nameAndTypeIndex;
    }

    public Symbol<Name> dynamicName(int dynamicIndex) {
        this.checkTag(dynamicIndex, (byte)17);
        int nameAndTypeIndex = this.dynamicNameAndTypeIndex(dynamicIndex);
        return this.unsafeUtf8At(this.nameAndTypeNameIndex(nameAndTypeIndex));
    }

    public Symbol<Type> dynamicType(int dynamicIndex) {
        this.checkTag(dynamicIndex, (byte)17);
        int nameAndTypeIndex = this.dynamicNameAndTypeIndex(dynamicIndex);
        return this.unsafeUtf8At(this.nameAndTypeDescriptorIndex(nameAndTypeIndex));
    }

    protected int moduleNameIndex(int moduleIndex) {
        this.checkTag(moduleIndex, (byte)19);
        int nameIndex = this.entries[moduleIndex] & 0xFFFF;
        return nameIndex;
    }

    protected int packageNameIndex(int packageIndex) {
        this.checkTag(packageIndex, (byte)20);
        int nameIndex = this.entries[packageIndex] & 0xFFFF;
        return nameIndex;
    }

    protected int nameAndTypeNameIndex(int nameAndTypeIndex) {
        this.checkTag(nameAndTypeIndex, (byte)12);
        int nameIndex = this.entries[nameAndTypeIndex] >>> 16;
        return nameIndex;
    }

    public Symbol<Name> nameAndTypeName(int nameAndTypeIndex) {
        return this.unsafeUtf8At(this.nameAndTypeNameIndex(nameAndTypeIndex));
    }

    public Symbol<? extends Descriptor> nameAndTypeDescriptor(int nameAndTypeIndex) {
        return this.unsafeUtf8At(this.nameAndTypeDescriptorIndex(nameAndTypeIndex));
    }

    public Symbol<Name> fieldName(int fieldIndex) {
        this.checkTag(fieldIndex, (byte)9);
        return this.nameAndTypeName(this.memberNameAndTypeIndex(fieldIndex));
    }

    public Symbol<Type> fieldType(int fieldIndex) {
        this.checkTag(fieldIndex, (byte)9);
        Symbol<Type> type = this.unsafeUtf8At(this.nameAndTypeDescriptorIndex(this.memberNameAndTypeIndex(fieldIndex)));
        assert (!this.validated || Validation.validFieldDescriptor(type));
        return type;
    }

    public Symbol<Name> methodName(int methodIndex) {
        this.checkMethodTag(methodIndex);
        Symbol<Name> name = this.nameAndTypeName(this.memberNameAndTypeIndex(methodIndex));
        assert (!this.validated || Validation.validMethodName(name));
        return name;
    }

    public Symbol<Signature> methodSignature(int methodIndex) {
        this.checkMethodTag(methodIndex);
        Symbol<? extends Descriptor> signature = this.nameAndTypeDescriptor(this.memberNameAndTypeIndex(methodIndex));
        assert (!this.validated || Validation.validSignatureDescriptor(signature));
        return signature;
    }

    protected int nameAndTypeDescriptorIndex(int nameAndTypeIndex) {
        this.checkTag(nameAndTypeIndex, (byte)12);
        int descriptorIndex = this.entries[nameAndTypeIndex] & 0xFFFF;
        return descriptorIndex;
    }

    public int memberClassIndex(int memberIndex) {
        this.checkMemberTag(memberIndex);
        int holderIndex = this.entries[memberIndex] >>> 16;
        return holderIndex;
    }

    public Symbol<Name> memberClassName(int memberIndex) {
        this.checkMemberTag(memberIndex);
        int holderIndex = this.entries[memberIndex] >>> 16;
        return this.className(holderIndex);
    }

    protected int memberNameAndTypeIndex(int memberIndex) {
        this.checkMemberTag(memberIndex);
        int nameAndTypeIndex = this.entries[memberIndex] & 0xFFFF;
        return nameAndTypeIndex;
    }

    public Symbol<Name> memberName(int memberIndex) {
        this.checkMemberTag(memberIndex);
        return this.nameAndTypeName(this.memberNameAndTypeIndex(memberIndex));
    }

    public Symbol<? extends Descriptor> memberDescriptor(int memberIndex) {
        this.checkMemberTag(memberIndex);
        return this.nameAndTypeDescriptor(this.memberNameAndTypeIndex(memberIndex));
    }

    public void validateConstantAt(int index, Tag expectedTag) throws ValidationException {
        this.validateTag(index, expectedTag.getValue());
        Tag tag = this.tagAt(index);
        switch (tag.ordinal()) {
            case 0: {
                assert (index == 0 || this.byteTagAt(index - 1) == 5 || this.byteTagAt(index - 1) == 6);
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                this.validateTag(index + 1, (byte)0);
                break;
            }
            case 1: {
                int symbolIndex = this.symbolEntryIndex(index);
                if (symbolIndex < 0 || this.symbols.length <= symbolIndex) {
                    throw ValidationException.raise("Bad symbol index for UTF8 entry: " + index);
                }
                this.utf8At(index).validateUTF8();
                break;
            }
            case 6: {
                int utf8Index = this.classNameIndex(index);
                this.validateConstantAt(utf8Index, Tag.UTF8);
                this.utf8At(utf8Index).validateClassName();
                break;
            }
            case 7: {
                int utf8Index = this.stringUtf8Index(index);
                this.validateConstantAt(utf8Index, Tag.UTF8);
                this.utf8At(utf8Index).validateUTF8();
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                int classIndex = this.memberClassIndex(index);
                this.validateConstantAt(classIndex, Tag.CLASS);
                int nameAndTypeIndex = this.memberNameAndTypeIndex(index);
                this.validateConstantAt(nameAndTypeIndex, Tag.NAME_AND_TYPE);
                int nameIndex = this.nameAndTypeNameIndex(nameAndTypeIndex);
                this.validateConstantAt(nameIndex, Tag.UTF8);
                int descriptorIndex = this.nameAndTypeDescriptorIndex(nameAndTypeIndex);
                this.validateConstantAt(descriptorIndex, Tag.UTF8);
                if (tag == Tag.FIELD_REF) {
                    this.utf8At(nameIndex).validateFieldName();
                    this.utf8At(descriptorIndex).validateType(false);
                    break;
                }
                Symbol<Name> name = this.utf8At(nameIndex).validateMethodName();
                Symbol<Signature> signature = this.utf8At(descriptorIndex).validateSignature();
                if (tag != Tag.METHOD_REF || name.length() <= 0 || name.byteAt(0) != 60 || ParserSymbols.ParserNames._init_.equals(name) && SignatureSymbols.returnsVoid(signature)) break;
                throw ValidationException.raise("<init> method must return void");
            }
            case 11: {
                int nameIndex = this.nameAndTypeNameIndex(index);
                this.validateConstantAt(nameIndex, Tag.UTF8);
                int descriptorIndex = this.nameAndTypeDescriptorIndex(index);
                this.validateConstantAt(descriptorIndex, Tag.UTF8);
                Symbol<?> name = this.utf8At(nameIndex);
                Symbol<?> descriptor = this.utf8At(descriptorIndex);
                if (descriptor.length() > 0 && descriptor.byteAt(0) == 40) {
                    name.validateMethodName();
                    descriptor.validateSignature();
                    break;
                }
                name.validateFieldName();
                descriptor.validateType(false);
                break;
            }
            case 12: {
                int refKind = this.methodHandleRefKind(index);
                int memberIndex = this.methodHandleMemberIndex(index);
                this.validateCPI(memberIndex);
                byte byteMemberTag = this.byteTagAt(memberIndex);
                if (byteMemberTag != 9 && byteMemberTag != 10 && byteMemberTag != 11) {
                    throw ValidationException.raise("Ill-formed constant: " + String.valueOf((Object)tag));
                }
                Tag memberTag = this.tagAt(memberIndex);
                this.validateConstantAt(memberIndex, memberTag);
                int nameAndTypeIndex = this.memberNameAndTypeIndex(memberIndex);
                this.validateConstantAt(nameAndTypeIndex, Tag.NAME_AND_TYPE);
                Symbol<Name> memberName = this.nameAndTypeName(nameAndTypeIndex);
                if (ParserSymbols.ParserNames._clinit_.equals(memberName)) {
                    throw ValidationException.raise("Ill-formed constant: " + String.valueOf((Object)tag));
                }
                if (ParserSymbols.ParserNames._init_.equals(memberName) && refKind != 8) {
                    throw ValidationException.raise("Ill-formed constant: " + String.valueOf((Object)tag));
                }
                if (1 > refKind || refKind > 9) {
                    throw ValidationException.raise("Ill-formed constant: " + String.valueOf((Object)tag));
                }
                if ((memberName.equals(ParserSymbols.ParserNames._init_) || memberName.equals(ParserSymbols.ParserNames._clinit_)) && (refKind == 5 || refKind == 6 || refKind == 7 || refKind == 9)) {
                    throw ValidationException.raise("Ill-formed constant: " + String.valueOf((Object)tag));
                }
                boolean valid = false;
                switch (refKind) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        valid = memberTag == Tag.FIELD_REF;
                        break;
                    }
                    case 5: 
                    case 8: {
                        valid = memberTag == Tag.METHOD_REF;
                        break;
                    }
                    case 6: 
                    case 7: {
                        valid = memberTag == Tag.METHOD_REF || this.getMajorVersion() >= 52 && memberTag == Tag.INTERFACE_METHOD_REF;
                        break;
                    }
                    case 9: {
                        boolean bl = valid = memberTag == Tag.INTERFACE_METHOD_REF;
                    }
                }
                if (valid) break;
                throw ValidationException.raise("Ill-formed constant: " + String.valueOf((Object)tag));
            }
            case 13: {
                int descriptorIndex = this.methodTypeDescriptorIndex(index);
                this.validateConstantAt(descriptorIndex, Tag.UTF8);
                Symbol<?> descriptor = this.utf8At(descriptorIndex);
                descriptor.validateSignature();
                break;
            }
            case 14: 
            case 15: {
                int nameAndTypeIndex = this.bsmNameAndTypeIndex(index);
                this.validateConstantAt(nameAndTypeIndex, Tag.NAME_AND_TYPE);
                Symbol<Name> name = this.nameAndTypeName(nameAndTypeIndex);
                Symbol<? extends Descriptor> descriptor = this.nameAndTypeDescriptor(nameAndTypeIndex);
                if (tag == Tag.DYNAMIC) {
                    name.validateFieldName();
                    descriptor.validateType(false);
                    break;
                }
                name.validateMethodName();
                descriptor.validateSignature();
                break;
            }
            case 16: {
                int nameIndex = this.moduleNameIndex(index);
                this.validateConstantAt(nameIndex, Tag.UTF8);
                Symbol<?> moduleName = this.utf8At(nameIndex, "module name");
                if (!Validation.validModuleName(moduleName)) break;
                throw ValidationException.raise("Invalid module name: " + String.valueOf(moduleName));
            }
            case 17: {
                int nameIndex = this.packageNameIndex(index);
                this.validateConstantAt(nameIndex, Tag.UTF8);
                Symbol<?> packageName = this.utf8At(nameIndex, "package name");
                if (!Validation.validPackageName(packageName)) break;
                throw ValidationException.raise("Invalid package name: " + String.valueOf(packageName));
            }
        }
    }

    private void validateTag(int index, byte expectedTag) throws ValidationException {
        byte tag = this.byteTagAt(this.validateCPI(index));
        if (tag != expectedTag) {
            throw ValidationException.raise("Unexpected constant pool tag");
        }
    }

    private int validateCPI(int index) throws ValidationException {
        if (index < 0 || index >= this.length()) {
            throw ValidationException.raise("Constant pool index out of bounds");
        }
        return index;
    }

    public void validate() throws ValidationException {
        for (int i = 0; i < this.length(); ++i) {
            this.validateConstantAt(i);
        }
        this.validated = true;
    }

    public void validateConstantAt(int index) throws ValidationException {
        this.validateConstantAt(index, this.validateTag(index));
    }

    public Tag validateTag(int index) throws ValidationException {
        this.validateCPI(index);
        byte byteTag = this.byteTagAt(index);
        if (byteTag == 0) {
            return Tag.INVALID;
        }
        Tag tag = Tag.fromValue(byteTag);
        if (tag == null) {
            throw ValidationException.raise("Illegal constant pool tag");
        }
        return tag;
    }

    private void dumpRawBytes(ByteBuffer bb) {
        block16: for (int i = 0; i < this.length(); ++i) {
            Tag tag = this.tagAt(i);
            if (tag == Tag.INVALID) continue;
            bb.put(this.byteTagAt(i));
            switch (tag.ordinal()) {
                case 1: {
                    Symbol<?> symbol = this.symbols[this.symbolEntryIndex(i)];
                    bb.putShort((short)symbol.length());
                    symbol.writeTo(bb);
                    continue block16;
                }
                case 2: {
                    bb.putInt(this.intAt(i));
                    continue block16;
                }
                case 3: {
                    bb.putFloat(this.floatAt(i));
                    continue block16;
                }
                case 4: {
                    bb.putLong(this.longAt(i));
                    continue block16;
                }
                case 5: {
                    bb.putDouble(this.doubleAt(i));
                    continue block16;
                }
                case 6: {
                    bb.putShort((short)this.classNameIndex(i));
                    continue block16;
                }
                case 7: {
                    bb.putShort((short)this.stringUtf8Index(i));
                    continue block16;
                }
                case 8: 
                case 9: 
                case 10: {
                    bb.putShort((short)this.memberClassIndex(i));
                    bb.putShort((short)this.memberNameAndTypeIndex(i));
                    continue block16;
                }
                case 11: {
                    bb.putShort((short)this.nameAndTypeNameIndex(i));
                    bb.putShort((short)this.nameAndTypeDescriptorIndex(i));
                    continue block16;
                }
                case 12: {
                    bb.put((byte)this.methodHandleRefKind(i));
                    bb.putShort((short)this.methodHandleMemberIndex(i));
                    continue block16;
                }
                case 14: 
                case 15: {
                    bb.putShort((short)this.bsmBootstrapMethodAttrIndex(i));
                    bb.putShort((short)this.bsmNameAndTypeIndex(i));
                    continue block16;
                }
                case 13: {
                    bb.putShort((short)this.methodTypeDescriptorIndex(i));
                    continue block16;
                }
                case 16: {
                    bb.putShort((short)this.moduleNameIndex(i));
                    continue block16;
                }
                case 17: {
                    bb.putShort((short)this.packageNameIndex(i));
                }
            }
        }
    }

    public boolean isSame(int thisIndex, int otherIndex, ConstantPool otherPool) {
        Tag tag = this.tagAt(thisIndex);
        if (tag != otherPool.tagAt(otherIndex)) {
            return false;
        }
        return switch (tag.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> false;
            case 1 -> {
                if (this.utf8At(thisIndex) == otherPool.utf8At(otherIndex)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.intAt(thisIndex) == otherPool.intAt(otherIndex)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (Float.floatToRawIntBits(this.floatAt(thisIndex)) == Float.floatToRawIntBits(otherPool.floatAt(otherIndex))) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (this.longAt(thisIndex) == otherPool.longAt(otherIndex)) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (Double.doubleToRawLongBits(this.doubleAt(thisIndex)) == Double.doubleToRawLongBits(otherPool.doubleAt(otherIndex))) {
                    yield true;
                }
                yield false;
            }
            case 6 -> this.isSame(this.classNameIndex(thisIndex), otherPool.classNameIndex(otherIndex), otherPool);
            case 7 -> this.isSame(this.stringUtf8Index(thisIndex), otherPool.stringUtf8Index(otherIndex), otherPool);
            case 8, 9, 10 -> {
                if (this.isSame(this.memberClassIndex(thisIndex), otherPool.memberClassIndex(otherIndex), otherPool) && this.isSame(this.memberNameAndTypeIndex(thisIndex), otherPool.memberNameAndTypeIndex(otherIndex), otherPool)) {
                    yield true;
                }
                yield false;
            }
            case 11 -> {
                if (this.isSame(this.nameAndTypeNameIndex(thisIndex), otherPool.nameAndTypeNameIndex(otherIndex), otherPool) && this.isSame(this.nameAndTypeDescriptorIndex(thisIndex), otherPool.nameAndTypeDescriptorIndex(otherIndex), otherPool)) {
                    yield true;
                }
                yield false;
            }
            case 12 -> {
                if (this.methodHandleRefKind(thisIndex) == otherPool.methodHandleRefKind(otherIndex) && this.isSame(this.methodHandleMemberIndex(thisIndex), otherPool.methodHandleMemberIndex(otherIndex), otherPool)) {
                    yield true;
                }
                yield false;
            }
            case 13 -> this.isSame(this.methodTypeDescriptorIndex(thisIndex), otherPool.methodTypeDescriptorIndex(otherIndex), otherPool);
            case 14, 15 -> {
                if (this.isSame(this.bsmNameAndTypeIndex(thisIndex), otherPool.bsmNameAndTypeIndex(otherIndex), otherPool) && this.bsmBootstrapMethodAttrIndex(thisIndex) == otherPool.bsmBootstrapMethodAttrIndex(otherIndex)) {
                    yield true;
                }
                yield false;
            }
            case 16 -> this.isSame(this.moduleNameIndex(thisIndex), otherPool.moduleNameIndex(otherIndex), otherPool);
            case 17 -> this.isSame(this.packageNameIndex(thisIndex), otherPool.packageNameIndex(otherIndex), otherPool);
        };
    }

    public String toString() {
        Formatter buf = new Formatter();
        for (int i = 0; i < this.length(); ++i) {
            buf.format("#%d = %-15s // %s%n", new Object[]{i, this.tagAt(i), this.toString(i)});
        }
        return buf.toString();
    }

    public byte[] toRawBytes() {
        int rawBytesSize = this.computeRawBytesSize();
        byte[] bytes = new byte[rawBytesSize];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        this.dumpRawBytes(bb);
        assert (!bb.hasRemaining());
        return bytes;
    }

    private int computeRawBytesSize() {
        int totalBytes = 0;
        for (int i = 0; i < this.length(); ++i) {
            Tag tag = this.tagAt(i);
            if (tag == Tag.INVALID) continue;
            ++totalBytes;
            totalBytes += (switch (tag.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> 0;
                case 1 -> 2 + this.utf8At(i).length();
                case 6, 7, 13, 16, 17 -> 2;
                case 12 -> 3;
                case 2, 3, 8, 9, 10, 11, 14, 15 -> 4;
                case 4, 5 -> 8;
            });
        }
        return totalBytes;
    }

    public boolean immutableContentEquals(ConstantPool that) {
        return Arrays.equals(this.tags, that.tags) && Arrays.equals(this.entries, that.entries) && Arrays.equals(this.symbols, that.symbols);
    }

    public static final class Tag
    extends Enum<Tag> {
        public static final /* enum */ Tag INVALID = new Tag(0);
        public static final /* enum */ Tag UTF8 = new Tag(1);
        public static final /* enum */ Tag INTEGER = new Tag(3, true);
        public static final /* enum */ Tag FLOAT = new Tag(4, true);
        public static final /* enum */ Tag LONG = new Tag(5, true);
        public static final /* enum */ Tag DOUBLE = new Tag(6, true);
        public static final /* enum */ Tag CLASS = new Tag(7, true);
        public static final /* enum */ Tag STRING = new Tag(8, true);
        public static final /* enum */ Tag FIELD_REF = new Tag(9);
        public static final /* enum */ Tag METHOD_REF = new Tag(10);
        public static final /* enum */ Tag INTERFACE_METHOD_REF = new Tag(11);
        public static final /* enum */ Tag NAME_AND_TYPE = new Tag(12);
        public static final /* enum */ Tag METHODHANDLE = new Tag(15, true);
        public static final /* enum */ Tag METHODTYPE = new Tag(16, true);
        public static final /* enum */ Tag DYNAMIC = new Tag(17, true);
        public static final /* enum */ Tag INVOKEDYNAMIC = new Tag(18);
        public static final /* enum */ Tag MODULE = new Tag(19);
        public static final /* enum */ Tag PACKAGE = new Tag(20);
        private final byte value;
        private final boolean loadable;
        private static final /* synthetic */ Tag[] $VALUES;

        public static Tag[] values() {
            return (Tag[])$VALUES.clone();
        }

        public static Tag valueOf(String name) {
            return Enum.valueOf(Tag.class, name);
        }

        private Tag(int value) {
            this(value, false);
        }

        private Tag(int value, boolean isLoadable) {
            assert ((byte)value == value);
            this.value = (byte)value;
            this.loadable = isLoadable;
        }

        public final byte getValue() {
            return this.value;
        }

        public final boolean isLoadable() {
            return this.loadable;
        }

        public final boolean isMember() {
            return this.isMethod() || this == FIELD_REF;
        }

        public boolean isPrimitive() {
            return 3 <= this.value && this.value <= 6;
        }

        public final boolean isMethod() {
            return this == METHOD_REF || this == INTERFACE_METHOD_REF;
        }

        public static Tag fromValue(int value) {
            return switch (value) {
                case 1 -> UTF8;
                case 3 -> INTEGER;
                case 4 -> FLOAT;
                case 5 -> LONG;
                case 6 -> DOUBLE;
                case 7 -> CLASS;
                case 8 -> STRING;
                case 9 -> FIELD_REF;
                case 10 -> METHOD_REF;
                case 11 -> INTERFACE_METHOD_REF;
                case 12 -> NAME_AND_TYPE;
                case 15 -> METHODHANDLE;
                case 16 -> METHODTYPE;
                case 17 -> DYNAMIC;
                case 18 -> INVOKEDYNAMIC;
                case 19 -> MODULE;
                case 20 -> PACKAGE;
                default -> null;
            };
        }

        public boolean isValidForVersion(int major) {
            return switch (this.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> true;
                case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> {
                    if (major >= 45) {
                        yield true;
                    }
                    yield false;
                }
                case 12, 13, 15 -> {
                    if (major >= 51) {
                        yield true;
                    }
                    yield false;
                }
                case 14 -> {
                    if (major >= 55) {
                        yield true;
                    }
                    yield false;
                }
                case 16, 17 -> major >= 53;
            };
        }

        private static /* synthetic */ Tag[] $values() {
            return new Tag[]{INVALID, UTF8, INTEGER, FLOAT, LONG, DOUBLE, CLASS, STRING, FIELD_REF, METHOD_REF, INTERFACE_METHOD_REF, NAME_AND_TYPE, METHODHANDLE, METHODTYPE, DYNAMIC, INVOKEDYNAMIC, MODULE, PACKAGE};
        }

        static {
            $VALUES = Tag.$values();
        }
    }
}

