/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.wasmgc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class WasmGCMetadata {
    private static final List<Class<?>> classes = new ArrayList();
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static final Map<Class<?>, Integer> classToIndex = new HashMap();
    private static final int RADIX = 36;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String registerClass(Class<?> clazz) {
        int index;
        assert (clazz != null);
        Integer possibleIndex = classToIndex.get(clazz);
        if (possibleIndex == null) {
            index = classes.size();
            classes.add(clazz);
            classToIndex.put(clazz, index);
        } else {
            index = possibleIndex;
        }
        return WasmGCMetadata.encodeClassIndex(index);
    }

    public static Class<?> lookupClass(String encoding) {
        return classes.get(WasmGCMetadata.decodeClassIndex(encoding));
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static String encodeClassIndex(int index) {
        return Integer.toUnsignedString(index, 36);
    }

    private static int decodeClassIndex(String encoding) {
        return Integer.parseUnsignedInt(encoding, 36);
    }
}

