/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.wasm.types;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.webimage.wasm.types.WasmPackedType;
import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmStorageType;
import com.oracle.svm.webimage.wasm.types.WasmValType;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteOrder;
import java.util.Objects;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.VoidStamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.graph.iterators.NodePredicate;
import jdk.graal.compiler.graph.iterators.NodePredicates;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderTool;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.CoreProvidersDelegate;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class WasmUtil {
    public static final int PAGE_SIZE = 65536;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final WasmPrimitiveType WORD_TYPE = WasmPrimitiveType.i64;
    protected final CoreProviders providers;
    private final GraphBuilderTool stubGraphBuilderTools;
    private final GraphBuilderConfiguration.Plugins graphBuilderPlugins;

    public WasmUtil(CoreProviders providers, GraphBuilderConfiguration.Plugins graphBuilderPlugins) {
        this.providers = providers;
        this.stubGraphBuilderTools = new StubGraphBuilderTools(providers);
        this.graphBuilderPlugins = graphBuilderPlugins;
    }

    public WasmValType mapType(JavaKind kind) {
        return this.storageTypeForKind(kind).toValType();
    }

    public WasmStorageType storageTypeForKind(JavaKind kind) {
        return switch (kind) {
            case JavaKind.Boolean, JavaKind.Byte -> WasmPackedType.i8;
            case JavaKind.Char, JavaKind.Short -> WasmPackedType.i16;
            case JavaKind.Int -> WasmPrimitiveType.i32;
            case JavaKind.Float -> WasmPrimitiveType.f32;
            case JavaKind.Long -> WasmPrimitiveType.i64;
            case JavaKind.Double -> WasmPrimitiveType.f64;
            case JavaKind.Object -> this.getJavaLangObjectType();
            default -> throw GraalError.shouldNotReachHere((String)kind.toString());
        };
    }

    public WasmValType typeForJavaClass(Class<?> clazz) {
        return this.typeForJavaType((JavaType)this.providers.getMetaAccess().lookupJavaType(clazz));
    }

    public WasmValType getJavaLangObjectType() {
        return this.typeForJavaClass(Object.class);
    }

    public WasmValType getHubObjectType() {
        return this.typeForJavaClass(DynamicHub.class);
    }

    public WasmValType getThrowableType() {
        return this.typeForJavaClass(Throwable.class);
    }

    public ResolvedJavaType canonicalizeJavaType(ResolvedJavaType type) {
        assert (type != null);
        return this.applyTypePlugins(type);
    }

    private ResolvedJavaType applyTypePlugins(ResolvedJavaType type) {
        assert (type != null);
        StampPair stampPair = this.graphBuilderPlugins.getOverridingStamp(this.stubGraphBuilderTools, (JavaType)type, false);
        if (stampPair == null) {
            return type;
        }
        return stampPair.getTrustedStamp().javaType(this.providers.getMetaAccess());
    }

    public static WasmPrimitiveType mapPrimitiveType(JavaKind kind) {
        assert (kind.isPrimitive()) : kind;
        return switch (kind) {
            case JavaKind.Boolean, JavaKind.Char, JavaKind.Byte, JavaKind.Short, JavaKind.Int -> WasmPrimitiveType.i32;
            case JavaKind.Float -> WasmPrimitiveType.f32;
            case JavaKind.Long -> WasmPrimitiveType.i64;
            case JavaKind.Double -> WasmPrimitiveType.f64;
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)kind.toString());
        };
    }

    public final WasmValType typeForJavaType(JavaType type) {
        return this.storageTypeForJavaType(type).toValType();
    }

    public abstract WasmStorageType storageTypeForJavaType(JavaType var1);

    public abstract WasmValType typeForNode(ValueNode var1);

    public final WasmValType typeForStamp(Stamp stamp) {
        WasmStorageType type = this.storageTypeForStamp(stamp);
        return type == null ? null : type.toValType();
    }

    public WasmStorageType storageTypeForStamp(Stamp stamp) {
        Stamp stamp2 = stamp;
        Objects.requireNonNull(stamp2);
        Stamp stamp3 = stamp2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractObjectStamp.class, PrimitiveStamp.class, VoidStamp.class}, (Object)stamp3, n)) {
            case 0 -> {
                AbstractObjectStamp objectStamp = (AbstractObjectStamp)stamp3;
                yield this.storageTypeForObjectStamp(objectStamp);
            }
            case 1 -> {
                PrimitiveStamp primitiveStamp = (PrimitiveStamp)stamp3;
                yield this.storageTypeForPrimitiveStamp(primitiveStamp);
            }
            case 2 -> {
                VoidStamp ignored = (VoidStamp)stamp3;
                yield null;
            }
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)(String.valueOf(stamp.getClass()) + " " + String.valueOf(stamp)));
        };
    }

    protected WasmStorageType storageTypeForObjectStamp(AbstractObjectStamp stamp) {
        return this.typeForJavaType((JavaType)stamp.javaType(this.providers.getMetaAccess()));
    }

    protected WasmStorageType storageTypeForPrimitiveStamp(PrimitiveStamp stamp) {
        return this.storageTypeForKind(stamp.javaType(this.providers.getMetaAccess()).getJavaKind());
    }

    protected JavaKind kindForStamp(Stamp stamp) {
        JavaKind kind = stamp.getStackKind();
        return switch (kind) {
            default -> throw new MatchException(null, null);
            case JavaKind.Boolean, JavaKind.Char, JavaKind.Byte, JavaKind.Short, JavaKind.Int -> JavaKind.Int;
            case JavaKind.Float, JavaKind.Long, JavaKind.Double, JavaKind.Object, JavaKind.Void, JavaKind.Illegal -> kind;
        };
    }

    public JavaKind kindForNode(ValueNode n) {
        if (n instanceof LogicNode) {
            return JavaKind.Boolean;
        }
        return this.kindForStamp(n.stamp(NodeView.DEFAULT));
    }

    public boolean hasValue(Node n) {
        if (n instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)n;
            JavaKind wasmKind = this.kindForNode(valueNode);
            return wasmKind != JavaKind.Illegal && wasmKind != JavaKind.Void;
        }
        return false;
    }

    public JavaKind memoryKind(Stamp accessStamp) {
        if (accessStamp instanceof IntegerStamp) {
            IntegerStamp integerStamp = (IntegerStamp)accessStamp;
            int bits = integerStamp.getBits();
            if (bits <= 8) {
                return JavaKind.Byte;
            }
            if (bits == 16) {
                return JavaKind.Short;
            }
            if (bits == 32) {
                return JavaKind.Int;
            }
            if (bits == 64) {
                return JavaKind.Long;
            }
            throw GraalError.shouldNotReachHere((String)accessStamp.toString());
        }
        if (accessStamp instanceof FloatStamp) {
            FloatStamp floatStamp = (FloatStamp)accessStamp;
            return switch (floatStamp.getBits()) {
                case 32 -> JavaKind.Float;
                case 64 -> JavaKind.Double;
                default -> throw GraalError.shouldNotReachHere((String)accessStamp.toString());
            };
        }
        throw GraalError.shouldNotReachHere((String)accessStamp.toString());
    }

    public JavaKind memoryKind(JavaKind kind) {
        return switch (kind) {
            case JavaKind.Boolean -> JavaKind.Byte;
            case JavaKind.Char -> JavaKind.Short;
            case JavaKind.Void, JavaKind.Illegal -> throw GraalError.shouldNotReachHere((String)kind.toString());
            default -> kind;
        };
    }

    public NodeIterable<Node> actualUsages(ValueNode node) {
        return node.usages().filter((NodePredicate)NodePredicates.isNotA(VirtualState.class));
    }

    private static class StubGraphBuilderTools
    extends CoreProvidersDelegate
    implements GraphBuilderTool {
        protected StubGraphBuilderTools(CoreProviders providers) {
            super(providers);
        }

        public <T extends Node> T append(T value) {
            throw GraalError.unimplementedOverride();
        }

        public StructuredGraph getGraph() {
            return null;
        }

        public boolean parsingIntrinsic() {
            return false;
        }
    }

    public static enum Extension {
        None,
        Sign,
        Zero;


        public static Extension forKind(JavaKind kind) {
            return switch (kind) {
                case JavaKind.Boolean, JavaKind.Char -> Zero;
                case JavaKind.Byte, JavaKind.Short -> Sign;
                case JavaKind.Int, JavaKind.Float, JavaKind.Long, JavaKind.Double, JavaKind.Object -> None;
                default -> throw VMError.shouldNotReachHere((String)kind.toString());
            };
        }
    }
}

