/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.wasm.types;

import com.oracle.svm.webimage.wasm.types.WasmValType;

public enum WasmPrimitiveType implements WasmValType
{
    i32,
    i64,
    f32,
    f64;


    @Override
    public boolean isInt() {
        return this == i32 || this == i64;
    }

    @Override
    public boolean isFloat() {
        return this == f32 || this == f64;
    }

    @Override
    public boolean isRef() {
        return false;
    }

    public int getBitCount() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 2 -> 32;
            case 1, 3 -> 64;
        };
    }

    public int getByteCount() {
        return this.getBitCount() / 8;
    }
}

