/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.wasm.types;

import com.oracle.svm.webimage.wasm.types.WasmPrimitiveType;
import com.oracle.svm.webimage.wasm.types.WasmStorageType;
import com.oracle.svm.webimage.wasm.types.WasmUtil;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;

public class WasmLMUtil
extends WasmUtil {
    public static final WasmPrimitiveType POINTER_TYPE = WasmPrimitiveType.i32;
    public static final JavaKind POINTER_KIND = JavaKind.Int;

    public WasmLMUtil(CoreProviders providers, GraphBuilderConfiguration.Plugins graphBuilderPlugins) {
        super(providers, graphBuilderPlugins);
    }

    @Override
    public WasmPrimitiveType mapType(JavaKind kind) {
        return (WasmPrimitiveType)super.mapType(kind);
    }

    @Override
    public WasmPrimitiveType typeForJavaClass(Class<?> clazz) {
        return POINTER_TYPE;
    }

    @Override
    public ResolvedJavaType canonicalizeJavaType(ResolvedJavaType type) {
        ResolvedJavaType canonical = super.canonicalizeJavaType(type);
        if (canonical.getJavaKind() == JavaKind.Object) {
            return this.providers.getMetaAccess().lookupJavaType(Object.class);
        }
        return canonical;
    }

    @Override
    public WasmStorageType storageTypeForJavaType(JavaType type) {
        ResolvedJavaType resolvedType = this.canonicalizeJavaType(type.resolve(null));
        return this.storageTypeForKind(resolvedType.getJavaKind());
    }

    @Override
    public WasmPrimitiveType typeForNode(ValueNode n) {
        return this.mapType(this.kindForNode(n));
    }

    @Override
    protected WasmPrimitiveType storageTypeForObjectStamp(AbstractObjectStamp stamp) {
        return POINTER_TYPE;
    }

    @Override
    protected JavaKind kindForStamp(Stamp stamp) {
        if (stamp.isPointerStamp()) {
            return POINTER_KIND;
        }
        return super.kindForStamp(stamp);
    }

    @Override
    public JavaKind memoryKind(Stamp accessStamp) {
        if (accessStamp instanceof AbstractPointerStamp) {
            return POINTER_KIND;
        }
        return super.memoryKind(accessStamp);
    }
}

