/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.wasm.stack;

import com.oracle.svm.webimage.wasm.types.WasmLMUtil;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.ValueKind;

public class WebImageWasmFrameMap
extends FrameMap {
    public WebImageWasmFrameMap(CodeCacheProvider codeCache, RegisterConfig registerConfig, FrameMap.ReferenceMapBuilderFactory referenceMapFactory) {
        super(codeCache, registerConfig, referenceMapFactory);
        this.spillSize = this.initialSpillSize = WebImageWasmFrameMap.frameSetupSize();
    }

    public int totalFrameSize() {
        int result = this.frameSize() + this.initialSpillSize;
        assert (result % this.getTarget().stackAlignment == 0) : "Total frame size not aligned: " + result;
        return result;
    }

    public static int frameSetupSize() {
        return WebImageWasmFrameMap.getIPSize();
    }

    @Fold
    public static int getIPSize() {
        return WasmLMUtil.POINTER_TYPE.getByteCount();
    }

    public int currentFrameSize() {
        return this.alignFrameSize(this.outgoingSize + this.spillSize - this.initialSpillSize);
    }

    public int spillSlotSize(ValueKind<?> kind) {
        return WasmLMUtil.POINTER_TYPE.getByteCount();
    }

    protected int alignFrameSize(int size) {
        return NumUtil.roundUp((int)(size + this.initialSpillSize), (int)this.getTarget().stackAlignment) - this.initialSpillSize;
    }
}

