/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.wasm.code;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.webimage.wasm.code.WasmCodeInfoQueryResult;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.WordBase;

public class WasmCodeInfoHolder {
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    private static WasmCodeInfoQueryResult[] codeInfos = null;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static WasmCodeInfoQueryResult getCodeInfo(CodePointer ip) {
        int maxIP = codeInfos.length;
        long raw = ip.rawValue();
        if (Word.unsigned((long)raw).aboveOrEqual(maxIP)) {
            throw WasmCodeInfoHolder.reportInvalidIp(ip);
        }
        return codeInfos[(int)raw];
    }

    @Uninterruptible(reason="Switch to interruptible code for fatal error reporting.", calleeMustBe=false)
    private static RuntimeException reportInvalidIp(CodePointer ip) {
        Log.log().hex((WordBase)ip).newline();
        throw VMError.shouldNotReachHere((String)"Tried to look up out-of-range IP");
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setCodeInfos(WasmCodeInfoQueryResult[] codeInfos) {
        WasmCodeInfoHolder.codeInfos = codeInfos;
    }
}

