/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.truffle;

import java.lang.reflect.Type;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class WebImageTruffleGraphBuilderPlugins {
    public static void register(InvocationPlugins plugins) {
        WebImageTruffleGraphBuilderPlugins.registerTStringPlugins(plugins);
        WebImageTruffleGraphBuilderPlugins.registerArrayUtilsPlugins(plugins);
        WebImageTruffleGraphBuilderPlugins.registerExactMathPlugins(plugins);
    }

    private static void registerTStringPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.oracle.truffle.api.strings.TStringOps").setAllowOverwrite(true);
        InvocationPlugins.OptionalLazySymbol nodeType = new InvocationPlugins.OptionalLazySymbol("com.oracle.truffle.api.nodes.Node");
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfAny1", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfAny2", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfAny3", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1, ValueNode v2) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfAny4", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1, ValueNode v2, ValueNode v3) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfRange1", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfRange2", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1, ValueNode v2, ValueNode v3) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOfTable", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, byte[].class}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode tables) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runIndexOf2ConsecutiveWithStride", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative, ValueNode fromIndex, ValueNode v0, ValueNode v1) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runRegionEqualsWithStride", new Type[]{nodeType, byte[].class, Long.TYPE, Boolean.TYPE, byte[].class, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode isNativeA, ValueNode arrayB, ValueNode offsetB, ValueNode isNativeB, ValueNode length, ValueNode dynamicStrides) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runMemCmp", new Type[]{nodeType, byte[].class, Long.TYPE, Boolean.TYPE, byte[].class, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode isNativeA, ValueNode arrayB, ValueNode offsetB, ValueNode isNativeB, ValueNode length, ValueNode dynamicStrides) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runArrayCopy", new Type[]{nodeType, byte[].class, Long.TYPE, Boolean.TYPE, byte[].class, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode isNativeA, ValueNode arrayB, ValueNode offsetB, ValueNode isNativeB, ValueNode length, ValueNode dynamicStrides) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runArrayCopy", new Type[]{nodeType, char[].class, Long.TYPE, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runArrayCopy", new Type[]{nodeType, int[].class, Long.TYPE, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length, ValueNode dynamicStrides) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runByteSwapS1", new Type[]{nodeType, byte[].class, Long.TYPE, Boolean.TYPE, byte[].class, Long.TYPE, Boolean.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode isNativeA, ValueNode arrayB, ValueNode offsetB, ValueNode isNativeB, ValueNode length) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runByteSwapS2", new Type[]{nodeType, byte[].class, Long.TYPE, Boolean.TYPE, byte[].class, Long.TYPE, Boolean.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode arrayA, ValueNode offsetA, ValueNode isNativeA, ValueNode arrayB, ValueNode offsetB, ValueNode isNativeB, ValueNode length) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesLatin1", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Boolean.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode isNative) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesBMP", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Boolean.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode isNative) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesUTF8", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode isNative, ValueNode assumeValid) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesUTF16", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode isNative, ValueNode assumeValid) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesUTF16C", new Type[]{nodeType, char[].class, Long.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesUTF32", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Boolean.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode isNative) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runCalcStringAttributesUTF32I", new Type[]{nodeType, int[].class, Long.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("runHashCode", new Type[]{nodeType, byte[].class, Long.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode location, ValueNode array, ValueNode offset, ValueNode length, ValueNode stride, ValueNode isNative) {
                return false;
            }
        });
    }

    private static void registerArrayUtilsPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.oracle.truffle.api.ArrayUtils").setAllowOverwrite(true);
        for (Stride stride : new Stride[]{Stride.S1, Stride.S2}) {
            r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfB1" + stride.name(), new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0) {
                    return false;
                }
            });
            r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfB2" + stride.name(), new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1) {
                    return false;
                }
            });
            r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfB3" + stride.name(), new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1, ValueNode v2) {
                    return false;
                }
            });
            r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfB4" + stride.name(), new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1, ValueNode v2, ValueNode v3) {
                    return false;
                }
            });
        }
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfC1S2", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfC2S2", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfC3S2", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1, ValueNode v2) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOfC4S2", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1, ValueNode v2, ValueNode v3) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOf2ConsecutiveS1", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOf2ConsecutiveS2", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubIndexOf2ConsecutiveS2", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode array, ValueNode fromIndex, ValueNode maxIndex, ValueNode v0, ValueNode v1) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubRegionEqualsS1", new Type[]{byte[].class, Long.TYPE, byte[].class, Long.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext graph, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubRegionEqualsS2S1", new Type[]{byte[].class, Long.TYPE, byte[].class, Long.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext graph, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length) {
                return false;
            }
        });
        r.register((InvocationPlugin)new InvocationPlugin.InlineOnlyInvocationPlugin("stubRegionEqualsS2", new Type[]{char[].class, Long.TYPE, char[].class, Long.TYPE, Integer.TYPE}){

            public boolean apply(GraphBuilderContext graph, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arrayA, ValueNode offsetA, ValueNode arrayB, ValueNode offsetB, ValueNode length) {
                return false;
            }
        });
    }

    public static void registerExactMathPlugins(InvocationPlugins plugins) {
        plugins.registerIntrinsificationPredicate(t -> t.getName().equals("Lcom/oracle/truffle/api/ExactMath;"));
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.oracle.truffle.api.ExactMath").setAllowOverwrite(true);
        for (JavaKind floatKind : new JavaKind[]{JavaKind.Float, JavaKind.Double}) {
            for (JavaKind integerKind : new JavaKind[]{JavaKind.Int, JavaKind.Long}) {
                r.register((InvocationPlugin)new InvocationPlugin.OptionalInvocationPlugin(integerKind == JavaKind.Long ? "truncateToUnsignedLong" : "truncateToUnsignedInt", new Type[]{floatKind.toJavaClass()}){

                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x) {
                        return false;
                    }
                });
            }
            r.register((InvocationPlugin)new InvocationPlugin.OptionalInvocationPlugin(floatKind == JavaKind.Double ? "unsignedToDouble" : "unsignedToFloat", new Type[]{Long.TYPE}){

                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x) {
                    return false;
                }
            });
        }
    }
}

