/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.truffle;

import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.webimage.truffle.WebImageTruffleGraphBuilderPlugins;
import java.util.ArrayList;
import java.util.List;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeSystemProperties;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticallyRegisteredFeature
public class WebImageTruffleFeature
implements InternalFeature {
    public static boolean isEnabled() {
        return (Boolean)Options.EnableTruffle.getValue();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        String[] classNames = new String[]{"com.oracle.svm.truffle.TruffleBaseFeature", "com.oracle.svm.hosted.webimage.WebImageFeature"};
        ArrayList<Class<? extends Feature>> featureClasses = new ArrayList<Class<? extends Feature>>(classNames.length);
        for (String className : classNames) {
            featureClasses.add(ReflectionUtil.lookupClass((String)className));
        }
        return featureClasses;
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return WebImageTruffleFeature.isEnabled();
    }

    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        WebImageTruffleGraphBuilderPlugins.register(plugins.getInvocationPlugins());
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        RuntimeClassInitializationSupport rci = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        rci.initializeAtBuildTime("com.oracle.truffle", "initialized by com.oracle.svm.truffle");
        rci.initializeAtBuildTime("org.graalvm.wasm", "initialized by com.oracle.svm.truffle");
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        RuntimeSystemProperties.register((String)"polyglot.engine.WarnInterpreterOnly", (String)"false");
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> EnableTruffle = new HostedOptionKey((Object)false);
    }
}

