/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.threads;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.webimage.threads.WebImageSingleThreadedVMMutex;

final class WebImageSingleThreadedVMCondition
extends VMCondition {
    WebImageSingleThreadedVMCondition(WebImageSingleThreadedVMMutex mutex) {
        super((VMMutex)mutex);
    }

    @Uninterruptible(reason="Too early for safepoints.")
    public int initialize() {
        return 0;
    }

    @Uninterruptible(reason="The isolate teardown is in progress.")
    public int destroy() {
        return 0;
    }

    public void block() {
        VMError.shouldNotReachHere((String)"Cannot block in a single-threaded environment, because there is no other thread that could signal");
    }

    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public void blockNoTransition() {
        VMError.shouldNotReachHere((String)"Cannot block in a single-threaded environment, because there is no other thread that could signal");
    }

    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public void blockNoTransitionUnspecifiedOwner() {
        VMError.shouldNotReachHere((String)"Cannot block in a single-threaded environment, because there is no other thread that could signal");
    }

    public long block(long nanos) {
        VMError.shouldNotReachHere((String)"Cannot block in a single-threaded environment, because there is no other thread that could signal");
        return 0L;
    }

    @Uninterruptible(reason="Should only be called if the thread did an explicit transition to native earlier.", callerMustBe=true)
    public long blockNoTransition(long nanos) {
        VMError.shouldNotReachHere((String)"Cannot block in a single-threaded environment, because there is no other thread that could signal");
        return 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void signal() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void broadcast() {
    }
}

