/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.substitute.system;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.BasedOnJDKClass;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.webimage.substitute.system.Target_java_io_FileSystem_Web;
import com.oracle.svm.webimage.substitute.system.Target_java_io_File_Web;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import jdk.internal.util.StaticProperty;

@BasedOnJDKClass(className="java.io.UnixFileSystem")
public final class WebImageFileSystem {
    private static final int NAME_MAX = 255;
    private static final String ROOT = "/";
    protected static final char SLASH = '/';
    protected static final char COLON = ':';
    private static final String USER_DIR = StaticProperty.userDir();

    private WebImageFileSystem() {
    }

    public static char getSeparator() {
        return '/';
    }

    public static char getPathSeparator() {
        return ':';
    }

    private static String normalize(String pathname, int off) {
        int n;
        for (n = pathname.length(); n > off && pathname.charAt(n - 1) == '/'; --n) {
        }
        if (n == 0) {
            return ROOT;
        }
        if (n == off) {
            return pathname.substring(0, off);
        }
        StringBuilder sb = new StringBuilder(n);
        if (off > 0) {
            sb.append(pathname, 0, off);
        }
        int prevChar = 0;
        for (int i = off; i < n; ++i) {
            char c = pathname.charAt(i);
            if (prevChar == 47 && c == '/') continue;
            sb.append(c);
            prevChar = c;
        }
        return sb.toString();
    }

    public static String normalize(String pathname) {
        int doubleSlash = pathname.indexOf("//");
        if (doubleSlash >= 0) {
            return WebImageFileSystem.normalize(pathname, doubleSlash);
        }
        if (pathname.endsWith(ROOT)) {
            return WebImageFileSystem.normalize(pathname, pathname.length() - 1);
        }
        return pathname;
    }

    public static int prefixLength(String pathname) {
        return pathname.startsWith(ROOT) ? 1 : 0;
    }

    private static String trimSeparator(String s) {
        int len = s.length();
        if (len > 1 && s.charAt(len - 1) == '/') {
            return s.substring(0, len - 1);
        }
        return s;
    }

    public static String resolve(String parent, String child) {
        if (child.isEmpty()) {
            return parent;
        }
        if (child.charAt(0) == '/') {
            if (parent.equals(ROOT)) {
                return child;
            }
            return WebImageFileSystem.trimSeparator(parent + child);
        }
        if (parent.equals(ROOT)) {
            return WebImageFileSystem.trimSeparator(parent + child);
        }
        return WebImageFileSystem.trimSeparator(parent + ROOT + child);
    }

    public static String getDefaultParent() {
        return ROOT;
    }

    public static String fromURIPath(String path) {
        String p = path;
        if (p.endsWith(ROOT) && p.length() > 1) {
            p = p.substring(0, p.length() - 1);
        }
        return p;
    }

    public static boolean isAbsolute(File f) {
        return ((Target_java_io_File_Web)SubstrateUtil.cast((Object)f, Target_java_io_File_Web.class)).getPrefixLength() != 0;
    }

    public static boolean isInvalid(File f) {
        return f.getPath().indexOf(0) >= 0;
    }

    public static String resolve(File f) {
        if (WebImageFileSystem.isAbsolute(f)) {
            return f.getPath();
        }
        return WebImageFileSystem.resolve(USER_DIR, f.getPath());
    }

    public static String canonicalize(String path) throws IOException {
        return WebImageFileSystem.canonicalize0(path);
    }

    private static String canonicalize0(String path) throws IOException {
        return WebImageFileSystem.canonicalizePath(path).toString();
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+14/src/java.base/unix/native/libjava/canonicalize_md.c#L48-L125")
    public static Path canonicalizePath(String path) throws IOException {
        Path absolute = Path.of(path, new String[0]).toAbsolutePath();
        ArrayDeque<String> unresolvedSegments = new ArrayDeque<String>();
        Path current = absolute;
        do {
            if (Files.exists(current, new LinkOption[0])) {
                current = current.toRealPath(new LinkOption[0]);
                break;
            }
            Path fileName = current.getFileName();
            if (fileName == null) break;
            unresolvedSegments.push(fileName.toString());
        } while ((current = current.getParent()) != null);
        if (current == null) {
            current = Path.of(ROOT, new String[0]);
        }
        Path finalPath = current;
        for (String segment : unresolvedSegments) {
            finalPath = finalPath.resolve(segment);
        }
        return finalPath.normalize();
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+14/src/java.base/unix/native/libjava/UnixFileSystem_md.c#L116-L132")
    private static int getBooleanAttributes0(File f) {
        int rv = 0;
        Path p = f.toPath();
        if (Files.exists(p, new LinkOption[0])) {
            rv |= Target_java_io_FileSystem_Web.BA_EXISTS;
        }
        if (Files.isRegularFile(p, new LinkOption[0])) {
            rv |= Target_java_io_FileSystem_Web.BA_REGULAR;
        }
        if (Files.isDirectory(p, new LinkOption[0])) {
            rv |= Target_java_io_FileSystem_Web.BA_DIRECTORY;
        }
        return rv;
    }

    public static int getBooleanAttributes(File f) {
        int rv = WebImageFileSystem.getBooleanAttributes0(f);
        return rv | WebImageFileSystem.isHidden(f);
    }

    public static boolean hasBooleanAttributes(File f, int attributes) {
        int rv = WebImageFileSystem.getBooleanAttributes0(f);
        if ((attributes & Target_java_io_FileSystem_Web.BA_HIDDEN) != 0) {
            rv |= WebImageFileSystem.isHidden(f);
        }
        return (rv & attributes) == attributes;
    }

    private static int isHidden(File f) {
        return f.getName().startsWith(".") ? Target_java_io_FileSystem_Web.BA_HIDDEN : 0;
    }

    public static boolean checkAccess(File f, int access) {
        return WebImageFileSystem.checkAccess0(f, access);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+14/src/java.base/unix/native/libjava/UnixFileSystem_md.c#L134-L160")
    private static boolean checkAccess0(File f, int access) {
        Path p = f.toPath();
        if (access == Target_java_io_FileSystem_Web.ACCESS_READ) {
            return Files.isReadable(p);
        }
        if (access == Target_java_io_FileSystem_Web.ACCESS_WRITE) {
            return Files.isWritable(p);
        }
        if (access == Target_java_io_FileSystem_Web.ACCESS_EXECUTE) {
            return Files.isExecutable(p);
        }
        throw VMError.shouldNotReachHereUnexpectedInput((Object)access);
    }

    public static boolean setPermission(File f, int access, boolean enable, boolean owneronly) {
        return WebImageFileSystem.setPermission0(f, access, enable, owneronly);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+14/src/java.base/unix/native/libjava/UnixFileSystem_md.c#L163-L210")
    private static boolean setPermission0(File f, int access, boolean enable, boolean owneronly) {
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        if (access == Target_java_io_FileSystem_Web.ACCESS_READ) {
            permissions.add(PosixFilePermission.OWNER_READ);
            if (!owneronly) {
                permissions.add(PosixFilePermission.GROUP_READ);
                permissions.add(PosixFilePermission.OTHERS_READ);
            }
        } else if (access == Target_java_io_FileSystem_Web.ACCESS_WRITE) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
            if (!owneronly) {
                permissions.add(PosixFilePermission.GROUP_WRITE);
                permissions.add(PosixFilePermission.OTHERS_WRITE);
            }
        } else if (access == Target_java_io_FileSystem_Web.ACCESS_EXECUTE) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            if (!owneronly) {
                permissions.add(PosixFilePermission.GROUP_EXECUTE);
                permissions.add(PosixFilePermission.OTHERS_EXECUTE);
            }
        } else {
            throw VMError.shouldNotReachHereUnexpectedInput((Object)access);
        }
        Path p = f.toPath();
        try {
            HashSet<PosixFilePermission> currentPermissions = new HashSet<PosixFilePermission>(Files.getPosixFilePermissions(p, new LinkOption[0]));
            if (enable) {
                currentPermissions.addAll(permissions);
            } else {
                currentPermissions.removeAll(permissions);
            }
            Files.setPosixFilePermissions(p, currentPermissions);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static long getLastModifiedTime(File f) {
        return WebImageFileSystem.getLastModifiedTime0(f);
    }

    private static long getLastModifiedTime0(File f) {
        try {
            FileTime time = Files.getLastModifiedTime(f.toPath(), new LinkOption[0]);
            return time.toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static long getLength(File f) {
        return WebImageFileSystem.getLength0(f);
    }

    private static long getLength0(File f) {
        try {
            Path p = f.toPath();
            if (!Files.exists(p, new LinkOption[0]) || Files.isDirectory(p, new LinkOption[0])) {
                return 0L;
            }
            return Files.size(p);
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static boolean createFileExclusively(String path) throws IOException {
        return WebImageFileSystem.createFileExclusively0(path);
    }

    private static boolean createFileExclusively0(String path) throws IOException {
        try {
            Path p = Path.of(path, new String[0]);
            Files.createFile(p, new FileAttribute[0]);
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
    }

    public static boolean delete(File f) {
        return WebImageFileSystem.delete0(f);
    }

    private static boolean delete0(File f) {
        try {
            return Files.deleteIfExists(f.toPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String[] list(File f) {
        return WebImageFileSystem.list0(f);
    }

    private static String[] list0(File f) {
        String[] stringArray;
        block10: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(f.toPath());
            try {
                ArrayList<String> names = new ArrayList<String>();
                for (Path p : stream) {
                    Path fileName = p.getFileName();
                    assert (fileName != null);
                    names.add(fileName.toString());
                }
                stringArray = names.toArray(new String[0]);
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            stream.close();
        }
        return stringArray;
    }

    public static boolean createDirectory(File f) {
        return WebImageFileSystem.createDirectory0(f);
    }

    private static boolean createDirectory0(File f) {
        try {
            Files.createDirectory(f.toPath(), new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean rename(File f1, File f2) {
        return WebImageFileSystem.rename0(f1, f2);
    }

    private static boolean rename0(File f1, File f2) {
        try {
            Files.move(f1.toPath(), f2.toPath(), new CopyOption[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean setLastModifiedTime(File f, long time) {
        return WebImageFileSystem.setLastModifiedTime0(f, time);
    }

    private static boolean setLastModifiedTime0(File f, long time) {
        try {
            Files.setLastModifiedTime(f.toPath(), FileTime.fromMillis(time));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean setReadOnly(File f) {
        return WebImageFileSystem.setReadOnly0(f);
    }

    private static boolean setReadOnly0(File f) {
        return WebImageFileSystem.setPermission(f, Target_java_io_FileSystem_Web.ACCESS_WRITE, false, false);
    }

    public static File[] listRoots() {
        return new File[]{new File(ROOT)};
    }

    public static long getSpace(File f, int t) {
        return WebImageFileSystem.getSpace0(f, t);
    }

    private static long getSpace0(File f, int t) {
        try {
            FileStore store = Files.getFileStore(f.toPath());
            if (t == Target_java_io_FileSystem_Web.SPACE_TOTAL) {
                return store.getTotalSpace();
            }
            if (t == Target_java_io_FileSystem_Web.SPACE_FREE) {
                return store.getUnallocatedSpace();
            }
            if (t == Target_java_io_FileSystem_Web.SPACE_USABLE) {
                return store.getUsableSpace();
            }
            throw VMError.shouldNotReachHereUnexpectedInput((Object)t);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private static long getNameMax0() {
        return 255L;
    }

    public static int getNameMax(String path) {
        long nameMax = WebImageFileSystem.getNameMax0();
        if (nameMax > Integer.MAX_VALUE) {
            nameMax = Integer.MAX_VALUE;
        }
        return (int)nameMax;
    }

    public static int compare(File f1, File f2) {
        return f1.getPath().compareTo(f2.getPath());
    }

    public static int hashCode(File f) {
        return f.getPath().hashCode() ^ 0x12D591;
    }
}

