/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.substitute.system;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.webimage.substitute.WebImageUtil;
import com.oracle.svm.webimage.substitute.system.IsUnix;
import sun.security.provider.NativePRNG;

@TargetClass(value=NativePRNG.class, onlyWith={IsUnix.class})
final class Target_sun_security_NativePRNG_Web {
    Target_sun_security_NativePRNG_Web() {
    }

    @Substitute
    void engineSetSeed(byte[] seed) {
    }

    @Substitute
    void engineNextBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(WebImageUtil.random() * 256.0 - 128.0);
        }
    }

    @Substitute
    byte[] engineGenerateSeed(int numBytes) {
        byte[] bytes = new byte[numBytes];
        this.engineNextBytes(bytes);
        return bytes;
    }
}

