/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.substitute.system;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.webimage.functionintrinsics.JSFunctionIntrinsics;

@TargetClass(className="jdk.internal.misc.VM")
final class Target_jdk_internal_misc_VM_Web {
    Target_jdk_internal_misc_VM_Web() {
    }

    @Substitute
    public static String[] getRuntimeArguments() {
        throw new UnsupportedOperationException("VM.getRuntimeArguments");
    }

    @Substitute
    public static long getNanoTimeAdjustment(long offsetInSeconds) {
        long maxDiffSecs = 0x100000000L;
        long minDiffSecs = -4294967296L;
        long unixEpochMillis = JSFunctionIntrinsics.currentTimeMillis();
        long seconds = unixEpochMillis / 1000L;
        long nanos = unixEpochMillis % 1000L * 1000000L;
        long diff = seconds - offsetInSeconds;
        if (diff >= 0x100000000L || diff <= -4294967296L) {
            return -1L;
        }
        return diff * 1000000000L + nanos;
    }
}

