/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.substitute.system;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.webimage.substitute.system.WebImageTempFileHelperSupport;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.graalvm.nativeimage.ImageSingletons;

@TargetClass(value=Files.class)
final class Target_java_nio_file_Files_Web {
    Target_java_nio_file_Files_Web() {
    }

    @Substitute
    private static String probeContentType(Path path) throws IOException {
        if (path.toString().endsWith(".sl")) {
            return "application/x-sl";
        }
        throw new IOException();
    }

    @Substitute
    public static Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        return ((WebImageTempFileHelperSupport)ImageSingletons.lookup(WebImageTempFileHelperSupport.class)).createTempFile(Objects.requireNonNull(dir), prefix, suffix, attrs);
    }

    @Substitute
    public static Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        return ((WebImageTempFileHelperSupport)ImageSingletons.lookup(WebImageTempFileHelperSupport.class)).createTempFile(null, prefix, suffix, attrs);
    }

    @Substitute
    public static Path createTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) throws IOException {
        return ((WebImageTempFileHelperSupport)ImageSingletons.lookup(WebImageTempFileHelperSupport.class)).createTempDirectory(Objects.requireNonNull(dir), prefix, attrs);
    }

    @Substitute
    public static Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) throws IOException {
        return ((WebImageTempFileHelperSupport)ImageSingletons.lookup(WebImageTempFileHelperSupport.class)).createTempDirectory(null, prefix, attrs);
    }
}

