/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.substitute.system;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.webimage.functionintrinsics.JSFunctionIntrinsics;

@TargetClass(value=System.class)
final class Target_java_lang_System_Web {
    Target_java_lang_System_Web() {
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long currentTimeMillis() {
        return JSFunctionIntrinsics.currentTimeMillis();
    }

    @Substitute
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static long nanoTime() {
        return (long)(JSFunctionIntrinsics.performanceNow() * 1000000.0);
    }

    @Substitute
    private static void exit(int status) {
        JSFunctionIntrinsics.exit(status);
    }

    @Substitute
    public static void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        JSFunctionIntrinsics.arrayCopy(src, srcPos, dest, destPos, length);
    }

    @Substitute
    public static String mapLibraryName(String libname) {
        return libname;
    }
}

