/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.substitute.system;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.webimage.functionintrinsics.JSFunctionIntrinsics;
import com.oracle.svm.webimage.platform.WebImageJSPlatform;
import com.oracle.svm.webimage.platform.WebImagePlatform;
import com.oracle.svm.webimage.platform.WebImageWasmGCPlatform;
import org.graalvm.nativeimage.Platforms;

@TargetClass(value=StrictMath.class)
@Platforms(value={WebImagePlatform.class})
final class Target_java_lang_StrictMath_Web {
    Target_java_lang_StrictMath_Web() {
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double sin(double a) {
        return JSFunctionIntrinsics.sin(a);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double cos(double a) {
        return JSFunctionIntrinsics.cos(a);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double tan(double a) {
        return JSFunctionIntrinsics.tan(a);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double asin(double a) {
        return JSFunctionIntrinsics.asin(a);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double acos(double a) {
        return JSFunctionIntrinsics.acos(a);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double atan(double a) {
        return JSFunctionIntrinsics.atan(a);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double exp(double a) {
        return JSFunctionIntrinsics.exp(a);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double log(double a) {
        return JSFunctionIntrinsics.log(a);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double log10(double a) {
        return JSFunctionIntrinsics.log10(a);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double sqrt(double a) {
        return JSFunctionIntrinsics.sqrt(a);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double cbrt(double a) {
        return JSFunctionIntrinsics.cbrt(a);
    }

    @Substitute
    private static double IEEEremainder(double f1, double f2) {
        return JSFunctionIntrinsics.IEEEremainder(f1, f2);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double atan2(double y, double x) {
        return JSFunctionIntrinsics.atan2(y, x);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double pow(double a, double b) {
        return JSFunctionIntrinsics.pow(a, b);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double sinh(double x) {
        return JSFunctionIntrinsics.sinh(x);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double cosh(double x) {
        return JSFunctionIntrinsics.cosh(x);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double tanh(double x) {
        return JSFunctionIntrinsics.tanh(x);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double hypot(double x, double y) {
        return JSFunctionIntrinsics.hypot(x, y);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double expm1(double x) {
        return JSFunctionIntrinsics.expm1(x);
    }

    @Substitute
    @Platforms(value={WebImageJSPlatform.class, WebImageWasmGCPlatform.class})
    private static double log1p(double x) {
        return JSFunctionIntrinsics.log1p(x);
    }
}

