/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.substitute.system;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Inject;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.webimage.print.WebImageOutErrPrinters;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

@TargetClass(value=FileOutputStream.class)
final class Target_java_io_FileOutputStream_Web {
    @Inject
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    OutputStream virtualOutputStream;
    @Alias
    private FileDescriptor fd;

    Target_java_io_FileOutputStream_Web() {
    }

    @Substitute
    private static void initIDs() {
    }

    @Substitute
    private void write(int b, boolean append) throws IOException {
        if (this.fd == FileDescriptor.out) {
            WebImageOutErrPrinters.out.write(b);
        } else if (this.fd == FileDescriptor.err) {
            WebImageOutErrPrinters.err.write(b);
        } else {
            this.virtualOutputStream.write(b);
        }
    }

    @Substitute
    private void writeBytes(byte[] b, int off, int len, boolean append) throws IOException {
        if (this.fd == FileDescriptor.out) {
            WebImageOutErrPrinters.out.write(b, off, len);
        } else if (this.fd == FileDescriptor.err) {
            WebImageOutErrPrinters.err.write(b, off, len);
        } else {
            this.virtualOutputStream.write(b, off, len);
        }
    }

    @Substitute
    private void open0(String name, boolean append) throws IOException {
        this.virtualOutputStream = append ? Files.newOutputStream(Paths.get(name, new String[0]), StandardOpenOption.APPEND) : Files.newOutputStream(Paths.get(name, new String[0]), new OpenOption[0]);
    }
}

