/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.substitute.system;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.webimage.functionintrinsics.JSInternalErrors;
import com.oracle.svm.webimage.platform.WebImageJSPlatform;
import org.graalvm.nativeimage.Platforms;

@TargetClass(value=VMError.class)
@Platforms(value={WebImageJSPlatform.class})
final class Target_com_oracle_svm_core_util_VMError_Web {
    Target_com_oracle_svm_core_util_VMError_Web() {
    }

    @Substitute
    private static RuntimeException shouldNotReachHere(String msg) {
        throw JSInternalErrors.shouldNotReachHere(msg);
    }

    @Substitute
    private static RuntimeException shouldNotReachHere(Throwable ex) {
        throw Target_com_oracle_svm_core_util_VMError_Web.shouldNotReachHere(ex.toString());
    }

    @Substitute
    private static RuntimeException shouldNotReachHere(String msg, Throwable ex) {
        throw Target_com_oracle_svm_core_util_VMError_Web.shouldNotReachHere("should not reach here: " + msg + "\n" + String.valueOf(ex));
    }

    @Substitute
    private static RuntimeException shouldNotReachHereSubstitution() {
        throw JSInternalErrors.shouldNotReachHere("should not reach here: substitution reached at runtime");
    }

    @Substitute
    private static RuntimeException shouldNotReachHereUnexpectedInput(Object input) {
        throw JSInternalErrors.shouldNotReachHere("should not reach here: unexpected input could not be handled");
    }

    @Substitute
    private static RuntimeException shouldNotReachHereAtRuntime() {
        throw JSInternalErrors.shouldNotReachHere("should not reach here: this code is expected to be unreachable at runtime");
    }

    @Substitute
    private static RuntimeException shouldNotReachHereOverrideInChild() {
        throw JSInternalErrors.shouldNotReachHere("should not reach here: method should have been overridden in child");
    }

    @Substitute
    private static RuntimeException unsupportedPlatform() {
        throw JSInternalErrors.shouldNotReachHere("should not reach here: unsupported platform");
    }

    @Substitute
    private static RuntimeException intentionallyUnimplemented() {
        throw Target_com_oracle_svm_core_util_VMError_Web.unsupportedFeature("unimplemented");
    }

    @Substitute
    private static RuntimeException unsupportedFeature(String msg) {
        throw new Error("UNSUPPORTED FEATURE: " + msg);
    }
}

