/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.substitute;

import com.oracle.svm.webimage.annotation.JSRawCall;
import jdk.internal.misc.Unsafe;
import org.graalvm.webimage.api.JS;

public class WebImageUtil {
    @JSRawCall
    @JS(value="return Math.random();")
    public static native double random();

    public static void unsafeSetMemory(Object destBase, long destOffset, long bytes, byte bvalue) {
        if (destBase == null) {
            for (long i = 0L; i < bytes; ++i) {
                Unsafe.getUnsafe().putByte(destOffset + i, bvalue);
            }
        } else {
            assert (destBase.getClass().isArray()) : destBase.getClass();
            for (long i = 0L; i < bytes; ++i) {
                Unsafe.getUnsafe().putByte(destBase, destOffset + i, bvalue);
            }
        }
    }

    public static void unsafeCopyMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        for (long i = 0L; i < bytes; ++i) {
            byte b = srcBase == null ? Unsafe.getUnsafe().getByte(srcOffset + i) : Unsafe.getUnsafe().getByte(srcBase, srcOffset + i);
            if (destBase == null) {
                Unsafe.getUnsafe().putByte(destOffset + i, b);
                continue;
            }
            Unsafe.getUnsafe().putByte(destBase, destOffset + i, b);
        }
    }
}

