/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.substitute;

import com.oracle.svm.webimage.annotation.JSRawCall;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.webimage.api.JS;

public final class WebImageHttpHandlerSubstitutions {
    static URLConnection openConnection(URL u, Proxy p) throws IOException {
        if (p != null) {
            throw new IOException("Cannot set proxy from JavaScript");
        }
        return new XhrUrlConnection(u);
    }

    private static final class XhrUrlConnection
    extends URLConnection {
        private byte[] content;

        XhrUrlConnection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            if (this.content != null) {
                return;
            }
            if (!this.jsConnect(this.url.toExternalForm())) {
                throw new IOException(this.jsGetMessage());
            }
            this.content = this.jsGetContent();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return new ByteArrayInputStream(this.content);
        }

        @JSRawCall
        @JS(value="try {\n    if('window' in self) {\n        this.r = 'HTTP(S) URL connections are not allowed on main thread';\n        return false;\n    }\n    var xhr = new XMLHttpRequest();\n    xhr.open('GET', urlString.toJSString(), false);\n    xhr.responseType = 'arraybuffer';\n    xhr.send();\n    if(xhr.status === 200) {\n        this.r = new Int8Array(xhr.response);\n        return true;\n    } else {\n        this.r = xhr.status + ' ' + xhr.statusText;\n        return false;\n    }\n} catch(e) {\n    this.r = e.toString();\n    return false;\n}\n")
        private native boolean jsConnect(String var1);

        @JS.Coerce
        @JS(value="var request = this[runtime.symbol.javaNative]; var r = request.r; request.r = null; return r;")
        private native byte[] jsGetContent();

        @JS.Coerce
        @JS(value="var request = this[runtime.symbol.javaNative]; var r = request.r; request.r = null; return r;")
        private native String jsGetMessage();
    }

    static final class Enabled
    implements BooleanSupplier {
        Enabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(WebImageHttpHandlerSubstitutions.class);
        }
    }
}

