/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.reflect;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import com.oracle.svm.core.heap.UnknownObjectField;
import com.oracle.svm.core.reflect.RuntimeMetadataDecoder;
import com.oracle.svm.webimage.platform.WebImagePlatform;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@AutomaticallyRegisteredImageSingleton(value={RuntimeMetadataDecoder.MetadataAccessor.class})
@Platforms(value={WebImagePlatform.class})
public class WebImageMetadataAccessor
implements RuntimeMetadataDecoder.MetadataAccessor {
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    private Object[] constants;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    private Class<?>[] classes;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    private String[] memberNames;
    @UnknownObjectField(availability=BuildPhaseProvider.AfterCompilation.class)
    private String[] otherStrings;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void installMetadata(JavaConstant[] constantsArray, Class<?>[] classesArray, String[] memberNamesArray, String[] otherStringsArray, CodeInfoEncoder codeInfoEncoder) {
        this.constants = new Object[constantsArray.length];
        for (int i = 0; i < constantsArray.length; ++i) {
            this.constants[i] = codeInfoEncoder.getFrameInfoEncoder().getConstantAccess().asObject(constantsArray[i]);
        }
        this.classes = classesArray;
        this.memberNames = memberNamesArray;
        this.otherStrings = otherStringsArray;
    }

    public <T> T getObject(int index, int layerId) {
        return (T)this.constants[index];
    }

    public Class<?> getClass(int index, int layerId) {
        return this.classes[index];
    }

    public String getMemberName(int index, int layerId) {
        return this.memberNames[index];
    }

    public String getOtherString(int index, int layerId) {
        return this.otherStrings[index];
    }
}

