/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.webimage.print;

import com.oracle.svm.webimage.print.JSDecodeBuffer;
import java.io.FileDescriptor;
import java.util.EnumMap;
import java.util.Map;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class WebImagePrintingProvider {
    private final Map<Descriptor, JSDecodeBuffer> decoder = new EnumMap<Descriptor, JSDecodeBuffer>(Descriptor.class);

    public WebImagePrintingProvider() {
        for (Descriptor fd : Descriptor.values()) {
            this.decoder.put(fd, new JSDecodeBuffer());
        }
    }

    @Fold
    public static WebImagePrintingProvider singleton() {
        return (WebImagePrintingProvider)ImageSingletons.lookup(WebImagePrintingProvider.class);
    }

    public void print(Descriptor fd, byte b) {
        this.decoder.get((Object)fd).write(b);
        this.decodeAll(fd);
    }

    public void print(Descriptor fd, byte[] b, int off, int len) {
        this.decoder.get((Object)fd).write(b, off, len);
        this.decodeAll(fd);
    }

    public abstract void print(Descriptor var1, char[] var2);

    public void newline(Descriptor fd) {
        this.print(fd, new char[]{'\n'});
    }

    public abstract void flush(Descriptor var1);

    public abstract void close(Descriptor var1);

    private void decodeAll(Descriptor fd) {
        JSDecodeBuffer buf = this.decoder.get((Object)fd);
        if (buf.hasNext()) {
            this.print(fd, buf.popAll());
        }
    }

    public static enum Descriptor {
        OUT(1),
        ERR(2);

        public final int num;

        private Descriptor(int num) {
            this.num = num;
        }

        public static Descriptor from(FileDescriptor fd) {
            if (fd == FileDescriptor.out) {
                return OUT;
            }
            if (fd == FileDescriptor.err) {
                return ERR;
            }
            return null;
        }
    }
}

